/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.ModifiedTimeConverter;
import it.unibz.instasearch.ui.InstaSearchUI;
import it.unibz.instasearch.ui.ResultContentProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;

class SearchContentProposalProvider
extends SimpleContentProposalProvider {
    private final IContentProposal[] EMPTY_PROPOSALS = new IContentProposal[0];
    private ResultContentProvider contentProvider;

    public SearchContentProposalProvider(ResultContentProvider contentProvider) {
        super(new String[0]);
        this.contentProvider = contentProvider;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String beforeCol;
        String curText = contents.substring(0, position);
        String rest = contents.substring(position);
        if (curText.endsWith(" ")) {
            return this.EMPTY_PROPOSALS;
        }
        int colIdx = curText.lastIndexOf(58);
        int spaceIdx = curText.lastIndexOf(32);
        if (colIdx == -1 || spaceIdx > colIdx) {
            return this.getPrefixProposals(curText, Field.CONTENTS, rest);
        }
        String fieldName = beforeCol = curText.substring(0, colIdx);
        if (spaceIdx != -1) {
            fieldName = beforeCol.substring(spaceIdx + 1);
        }
        fieldName = fieldName.toLowerCase(Locale.ENGLISH);
        List<String> proposalNames = null;
        int commaIdx = curText.lastIndexOf(44);
        String prevProposal = "";
        if (commaIdx > colIdx && commaIdx < position) {
            prevProposal = curText.substring(colIdx + 1, commaIdx + 1);
            colIdx = commaIdx;
        }
        String prefix = curText.substring(colIdx + 1).toLowerCase(Locale.ENGLISH);
        Field field = Field.getByName(fieldName);
        if (field == null) {
            return this.EMPTY_PROPOSALS;
        }
        proposalNames = this.getFieldProposals(field, prefix);
        if (proposalNames.size() == 0) {
            return this.EMPTY_PROPOSALS;
        }
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        if ("".equals(prefix) && field == Field.PROJ) {
            this.addCurrentProjectProposal(rest, beforeCol, prevProposal, proposals);
        }
        for (String proposalName : proposalNames) {
            if (!proposalName.toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            String label = proposalName;
            proposalName = String.valueOf(prevProposal) + proposalName;
            if (proposalName.contains(" ") && !proposalName.contains("\"")) {
                proposalName = "\"" + proposalName + "\"";
            }
            String proposalContent = String.valueOf(beforeCol) + ':' + proposalName + rest;
            int pos = beforeCol.length() + 1 + proposalName.length();
            proposals.add(this.makeContentProposal(proposalContent, label, pos));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    public List<String> getFieldProposals(Field field, String prefix) {
        List<String> proposalNames;
        switch (field) {
            case PROJ: {
                proposalNames = InstaSearchPlugin.getProjectNames();
                break;
            }
            case WS: {
                proposalNames = InstaSearchPlugin.getWorkingSets();
                break;
            }
            case MODIFIED: {
                proposalNames = ModifiedTimeConverter.getDurationNames();
                break;
            }
            case FILE: {
                return Collections.emptyList();
            }
            case DIR: {
                return Collections.emptyList();
            }
            default: {
                proposalNames = this.getIndexedProposals(prefix, field);
            }
        }
        return proposalNames;
    }

    private void addCurrentProjectProposal(String rest, String beforeCol, String prevProposal, ArrayList<IContentProposal> proposals) {
        if (InstaSearchUI.getActiveProject() != null) {
            String content = String.valueOf(beforeCol) + ":" + prevProposal + "." + rest;
            proposals.add(this.makeContentProposal(content, ". (Current Project)", beforeCol.length() + 2));
        }
    }

    private IContentProposal[] getPrefixProposals(String text, Field field, String rest) {
        String before;
        String prefix;
        if ("".equals(text.trim())) {
            return this.EMPTY_PROPOSALS;
        }
        int spaceIdx = text.lastIndexOf(32);
        if (spaceIdx != -1) {
            prefix = text.substring(spaceIdx + 1);
            before = text.substring(0, spaceIdx + 1);
        } else {
            prefix = text;
            before = "";
        }
        ArrayList<IContentProposal> contentProposals = new ArrayList<IContentProposal>();
        List<String> proposals = this.getIndexedProposals(prefix, field);
        if (proposals == null) {
            return this.EMPTY_PROPOSALS;
        }
        for (String proposal : proposals) {
            if (!proposal.toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
            String label = proposal;
            String proposalContent = String.valueOf(before) + proposal + rest;
            int pos = before.length() + proposal.length();
            contentProposals.add(this.makeContentProposal(proposalContent, label, pos));
        }
        return contentProposals.toArray(new IContentProposal[contentProposals.size()]);
    }

    private List<String> getIndexedProposals(String prefix, Field field) {
        List<String> proposals = null;
        try {
            proposals = this.contentProvider.getProposals(prefix, field);
        }
        catch (IOException iOException) {
            return null;
        }
        return proposals;
    }

    private IContentProposal makeContentProposal(final String proposalContent, final String label, final int position) {
        return new IContentProposal(){

            public String getContent() {
                return proposalContent;
            }

            public String getDescription() {
                return null;
            }

            public String getLabel() {
                return label;
            }

            public int getCursorPosition() {
                return position;
            }
        };
    }
}

