/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.ui.InstaSearchUI;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReportErrorDialog
extends ErrorDialog {
    private static final int REPORT_BUTTON_ID = 1025;
    private IStatus status;
    private Link newTicketLink;

    public ReportErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell, dialogTitle, message, status, displayMask);
        this.status = status;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1025, "Report", true);
    }

    protected List createDropDownList(Composite parent) {
        List list = super.createDropDownList(parent);
        if (this.newTicketLink == null) {
            this.newTicketLink = new Link(parent, 0);
            this.newTicketLink.setText("You can also open a <a>new ticket</a>");
            this.newTicketLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        InstaSearchUI.showHomePage();
                    }
                    catch (Exception ex) {
                        InstaSearchPlugin.log(ex);
                        ReportErrorDialog.this.newTicketLink.setEnabled(false);
                    }
                }
            });
            GridData data = new GridData(1808);
            data.horizontalSpan = 2;
            this.newTicketLink.setLayoutData((Object)data);
        }
        list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReportErrorDialog.this.newTicketLink.dispose();
                ReportErrorDialog.this.newTicketLink = null;
            }
        });
        return list;
    }

    public static void openReportError(Shell parentShell, String title, String message, IStatus status) {
        int displayMask = 7;
        ReportErrorDialog dialog = new ReportErrorDialog(parentShell, title, message, status, displayMask);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ReportErrorDialog.this.open();
            }
        });
    }

    protected void buttonPressed(int id) {
        if (id == 1025) {
            try {
                this.reportError();
                this.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                InstaSearchPlugin.log(e);
                InstaSearchUI.showMessage("Unable to send. Please open a ticket in project's site");
            }
        } else {
            super.buttonPressed(id);
        }
    }

    private void reportError() throws HttpException, IOException {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(InstaSearchPlugin.getErrorReportURL());
        postMethod.addParameter("subj", this.message);
        postMethod.addParameter("attn", "Exception");
        postMethod.addParameter("notes", this.getStatusContent(this.status));
        postMethod.addParameter("visitor", "InstaSearch Plugin " + InstaSearchPlugin.getVersion());
        httpClient.executeMethod((HttpMethod)postMethod);
        postMethod.releaseConnection();
    }

    private String getStatusContent(IStatus status) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.addProperty(printWriter, "version", InstaSearchPlugin.getVersion());
        this.addSystemProperty(printWriter, "osgi.framework.version");
        this.addSystemProperty(printWriter, "eclipse.buildId");
        this.addSystemProperty(printWriter, "java.version");
        this.addBundleProperty(printWriter, "org.osgi.framework.version");
        this.addBundleProperty(printWriter, "org.osgi.framework.os.name");
        this.addBundleProperty(printWriter, "org.osgi.framework.os.version");
        this.addStatusContent(printWriter, status);
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus st = iStatusArray[n2];
            this.addStatusContent(printWriter, st);
            ++n2;
        }
        return stringWriter.toString();
    }

    private void addBundleProperty(PrintWriter b, String prop) {
        this.addProperty(b, prop, InstaSearchPlugin.getDefault().getBundle().getBundleContext().getProperty(prop));
    }

    private void addSystemProperty(PrintWriter b, String prop) {
        this.addProperty(b, prop, System.getProperty(prop));
    }

    private void addProperty(PrintWriter b, String prop, String val) {
        b.print(prop);
        b.print(": ");
        b.println(val);
    }

    private void addStatusContent(PrintWriter b, IStatus status) {
        b.print("Status: ");
        b.println(status.getMessage());
        status.getException().printStackTrace(b);
        b.println();
    }
}

