/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.SearchResultDoc;
import it.unibz.instasearch.ui.ResultContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

class MatchHighlightJob
extends Job
implements ISchedulingRule,
IPartListener {
    private SearchResultDoc doc;
    private ResultContentProvider.MatchLine selectedLineMatches;
    private ResultContentProvider contentProvider;
    private ITextEditor editor;
    private Job searchJob;
    private IDocument document;
    private IWorkbenchPage workbenchPage;
    private IFile file;

    public MatchHighlightJob(SearchResultDoc doc, ResultContentProvider.MatchLine selectedLineMatches, ResultContentProvider contentProvider, Job searchJob, IWorkbenchPage workbenchPage) throws Exception {
        super("Highlight Matches");
        this.doc = doc;
        this.selectedLineMatches = selectedLineMatches;
        this.contentProvider = contentProvider;
        this.searchJob = searchJob;
        this.workbenchPage = workbenchPage;
        IEditorInput input = contentProvider.getEditorInput(doc);
        IEditorDescriptor editorDesc = IDE.getEditorDescriptor((String)doc.getFileName());
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)input, (String)editorDesc.getId());
        this.editor = this.getTextEditor(input, editorPart);
        this.document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        IStorage storage = contentProvider.getStorage(doc);
        this.file = null;
        if (storage instanceof IFile) {
            this.file = (IFile)storage;
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                if (this.editor != null) {
                    this.workbenchPage.addPartListener((IPartListener)this);
                    this.findAndHighlightMatches(this.doc, monitor);
                }
            }
            catch (Exception e) {
                InstaSearchPlugin.log(e);
                this.workbenchPage.removePartListener((IPartListener)this);
            }
        }
        finally {
            this.workbenchPage.removePartListener((IPartListener)this);
        }
        return Status.OK_STATUS;
    }

    private void findAndHighlightMatches(SearchResultDoc doc, IProgressMonitor monitor) throws Exception, BadLocationException, CoreException {
        if (this.file != null) {
            this.deleteMarkers();
            this.addMarkerRemover(this.file);
        }
        MatchHighliter highlighter = new MatchHighliter(monitor);
        if (this.selectedLineMatches != null) {
            highlighter.highlightMatchLine(this.file, this.selectedLineMatches);
        }
        this.contentProvider.getMatchLines(doc, false, highlighter);
    }

    private ITextEditor getTextEditor(IEditorInput input, IEditorPart editor) {
        if (editor instanceof MultiPageEditorPart) {
            IEditorPart[] editors;
            MultiPageEditorPart multiPageEditor = (MultiPageEditorPart)editor;
            IEditorPart[] iEditorPartArray = editors = multiPageEditor.findEditors(input);
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart ed = iEditorPartArray[n2];
                if (ed instanceof ITextEditor) {
                    multiPageEditor.setActiveEditor(ed);
                    return (ITextEditor)ed;
                }
                ++n2;
            }
        } else if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        return null;
    }

    private void addMarkerRemover(IFile file) {
        this.searchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                try {
                    MatchHighlightJob.this.cancel();
                    MatchHighlightJob.this.deleteMarkers();
                }
                finally {
                    MatchHighlightJob.this.searchJob.removeJobChangeListener((IJobChangeListener)this);
                }
            }
        });
    }

    public boolean contains(ISchedulingRule rule) {
        return rule.getClass() == ((Object)((Object)this)).getClass();
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule.getClass() == ((Object)((Object)this)).getClass();
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.editor) {
            this.cancel();
            this.deleteMarkers();
        }
    }

    private void deleteMarkers() {
        try {
            if (this.file != null) {
                this.file.deleteMarkers("org.eclipse.search.searchmarker", true, 2);
            }
        }
        catch (CoreException e) {
            InstaSearchPlugin.log((Exception)((Object)e));
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    private class MatchHighliter
    implements ResultContentProvider.MatchFindCallback {
        private IProgressMonitor monitor;
        private boolean matchSelected = false;

        public MatchHighliter(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void matchFound(ResultContentProvider.MatchLine line) {
            try {
                this.highlightMatchLine(MatchHighlightJob.this.file, line);
            }
            catch (Exception e) {
                InstaSearchPlugin.log(e);
                this.monitor.setCanceled(true);
            }
        }

        @Override
        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        protected void highlightMatchLine(IFile file, ResultContentProvider.MatchLine lineMatches) throws CoreException, BadLocationException {
            int lineNum = lineMatches.getLineNumber();
            if (MatchHighlightJob.this.document.getNumberOfLines() < lineNum) {
                return;
            }
            if (MatchHighlightJob.this.selectedLineMatches == null) {
                MatchHighlightJob.this.selectedLineMatches = lineMatches;
            }
            int pos = MatchHighlightJob.this.document.getLineOffset(lineNum - 1);
            for (Match match : lineMatches.getMatches()) {
                if (this.monitor.isCanceled()) break;
                MatchHighlightJob.this.editor.setHighlightRange(pos + match.getOffset(), match.getLength(), false);
                IMarker marker = this.createMarker(pos, lineNum, match, file, MatchHighlightJob.this.editor);
                if (MatchHighlightJob.this.selectedLineMatches == null || lineNum != MatchHighlightJob.this.selectedLineMatches.getLineNumber()) continue;
                if (marker != null && !this.matchSelected) {
                    this.gotoEditorMarker(marker);
                    this.matchSelected = true;
                }
                if (this.matchSelected) continue;
                int selectedOffset = pos + match.getOffset();
                int selectedLength = match.getLength();
                MatchHighlightJob.this.editor.setHighlightRange(selectedOffset, selectedLength, true);
                this.matchSelected = true;
            }
        }

        private IMarker createMarker(int pos, int lineNumber, Match match, IFile file, ITextEditor textEditor) throws CoreException {
            if (file == null) {
                return null;
            }
            IMarker marker = null;
            marker = file.createMarker("org.eclipse.search.searchmarker");
            marker.setAttribute("transient", true);
            marker.setAttribute("message", match.getElement());
            MarkerUtilities.setLineNumber((IMarker)marker, (int)lineNumber);
            MarkerUtilities.setCharStart((IMarker)marker, (int)(pos + match.getOffset()));
            MarkerUtilities.setCharEnd((IMarker)marker, (int)(pos + match.getOffset() + match.getLength()));
            return marker;
        }

        private void gotoEditorMarker(final IMarker selectedMarker) {
            if (selectedMarker == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IDE.gotoMarker((IEditorPart)MatchHighlightJob.this.editor, (IMarker)selectedMarker);
                }
            };
            MatchHighlightJob.this.editor.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }
}

