/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.ui;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.ui.InstaSearchView;
import it.unibz.instasearch.ui.ReportErrorDialog;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class InstaSearchUI {
    public static Shell getActiveShell() {
        if (PlatformUI.getWorkbench().getDisplay() != null) {
            return PlatformUI.getWorkbench().getDisplay().getActiveShell();
        }
        return null;
    }

    public static void showMessage(String message) {
        MessageDialog.openInformation((Shell)InstaSearchUI.getActiveShell(), (String)InstaSearchPlugin.getPluginName(), (String)message);
    }

    public static void showError(Exception ex) {
        String message = ex.getMessage();
        if (message == null || "".equals(message)) {
            message = ex.getClass().getName();
        }
        InstaSearchUI.showError(ex, message);
    }

    public static void showError(Throwable exception, String message) {
        Status status = new Status(4, InstaSearchPlugin.getPluginId(), message, exception);
        InstaSearchUI.showError((IStatus)status, message);
    }

    public static void showError(IStatus status, String message) {
        ReportErrorDialog.openReportError(InstaSearchUI.getActiveShell(), InstaSearchPlugin.getPluginName(), message, status);
        InstaSearchPlugin.log(status);
    }

    public static InstaSearchView showSearchView() {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (win != null && win.getActivePage() != null) {
            IViewPart view = null;
            try {
                view = win.getActivePage().showView(InstaSearchView.ID);
            }
            catch (PartInitException e) {
                InstaSearchPlugin.log((Exception)((Object)e));
                return null;
            }
            if (view == null) {
                return null;
            }
            if (view instanceof InstaSearchView) {
                return (InstaSearchView)view;
            }
        }
        return null;
    }

    public static boolean isSearchViewVisible() {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (win != null && win.getActivePage() != null) {
            IViewPart view = win.getActivePage().findView(InstaSearchView.ID);
            return win.getActivePage().isPartVisible((IWorkbenchPart)view);
        }
        return false;
    }

    public static void showHomePage() throws MalformedURLException, PartInitException {
        URL homePageUrl = new URL(InstaSearchPlugin.getHomePageLocation());
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(homePageUrl);
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static String getActiveProject() {
        IResource resource;
        IEditorPart editor = InstaSearchUI.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput adaptable = editor.getEditorInput();
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        if (project == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        if (project != null && project.isAccessible()) {
            return project.getName();
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        if (InstaSearchUI.getWorkbenchWindow() == null) {
            return null;
        }
        IWorkbenchPage activePage = InstaSearchUI.getWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IEditorPart activeEditor = activePage.getActiveEditor();
            return activeEditor;
        }
        return null;
    }

    public static Image getSharedImage(String img) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(img);
    }
}

