/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.jobs;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.actions.ShowExceptionAction;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressConstants;

public class UpdatePluginJob
extends WorkspaceJob {
    private static final String UPDATE_MANAGER_COMMAND = "org.eclipse.equinox.p2.ui.sdk.update";

    public UpdatePluginJob() {
        super("InstaSearch Update");
        this.setProperty(IProgressConstants.ICON_PROPERTY, InstaSearchPlugin.getImageDescriptor("update"));
        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.isSystem()) {
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
        }
        this.showUpdateManager();
        return new Status(0, InstaSearchPlugin.getPluginId(), 0, "Update Manager Launched", null);
    }

    private void showUpdateManager() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                if (handlerService != null) {
                    try {
                        handlerService.executeCommand(UpdatePluginJob.UPDATE_MANAGER_COMMAND, new Event());
                    }
                    catch (Exception e) {
                        InstaSearchPlugin.log(e);
                        UpdatePluginJob.this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new ShowExceptionAction(e, "Error Launching Update Manager"));
                    }
                }
            }
        });
    }
}

