/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class VisitableQuery {
    private Query query;

    public VisitableQuery(Query q) {
        this.query = q;
    }

    public void accept(QueryVisitor queryVisitor) {
        queryVisitor.init(this.query);
        this.query = this.accept(this.query, queryVisitor);
        this.query = queryVisitor.endVisit(this.query);
    }

    private Query accept(Query query, QueryVisitor queryVisitor) {
        Query returnQuery = query;
        if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            Field field = Field.getByName(termQuery.getTerm().field());
            Query newQuery = queryVisitor.visit(termQuery, field);
            newQuery.setBoost(query.getBoost());
            returnQuery = newQuery;
        } else if (query instanceof BooleanQuery) {
            BooleanQuery boolQuery = (BooleanQuery)query;
            BooleanQuery newBoolQuery = queryVisitor.visit(boolQuery);
            BooleanClause[] booleanClauseArray = boolQuery.getClauses();
            int n = booleanClauseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BooleanClause boolClause = booleanClauseArray[n2];
                if (queryVisitor.visit(boolClause)) {
                    Query newQuery = this.accept(boolClause.getQuery(), queryVisitor);
                    boolClause.setQuery(newQuery);
                }
                ++n2;
            }
            newBoolQuery.setBoost(boolQuery.getBoost());
            newBoolQuery.setMinimumNumberShouldMatch(boolQuery.getMinimumNumberShouldMatch());
            returnQuery = newBoolQuery;
        } else if (query instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)query;
            Query newQuery = this.accept(fq.getQuery(), queryVisitor);
            if (newQuery != fq.getQuery()) {
                FilteredQuery newFq = new FilteredQuery(fq.getQuery(), fq.getFilter());
                newFq.setBoost(fq.getBoost());
                returnQuery = newFq;
            }
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            returnQuery = queryVisitor.visit(phraseQuery);
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            Field field = Field.getByName(wildcardQuery.getTerm().field());
            Query newQuery = queryVisitor.visit(wildcardQuery, field);
            newQuery.setBoost(query.getBoost());
            returnQuery = newQuery;
        } else if (query instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)query;
            Field field = Field.getByName(prefixQuery.getPrefix().field());
            Query newQuery = queryVisitor.visit(prefixQuery, field);
            newQuery.setBoost(query.getBoost());
            returnQuery = newQuery;
        } else {
            returnQuery = queryVisitor.visitQuery(query);
        }
        return returnQuery;
    }

    public Query getQuery() {
        return this.query;
    }
}

