/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import java.util.Locale;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class LowercaseConverter
extends QueryVisitor {
    @Override
    public void init(Query query) {
    }

    @Override
    public Query visit(TermQuery termQuery, Field field) {
        if (field == Field.CONTENTS) {
            Term term = termQuery.getTerm();
            return new TermQuery(field.createTerm(term.text().toLowerCase(Locale.ENGLISH)));
        }
        return termQuery;
    }

    @Override
    public Query visit(PrefixQuery prefixQuery, Field field) {
        if (field == Field.CONTENTS) {
            Term term = prefixQuery.getPrefix();
            return new PrefixQuery(field.createTerm(term.text().toLowerCase(Locale.ENGLISH)));
        }
        return super.visit(prefixQuery, field);
    }

    @Override
    public Query visit(WildcardQuery wildcardQuery, Field field) {
        if (field == Field.CONTENTS) {
            Term term = wildcardQuery.getTerm();
            return new WildcardQuery(field.createTerm(term.text().toLowerCase(Locale.ENGLISH)));
        }
        return super.visit(wildcardQuery, field);
    }

    @Override
    public Query visit(PhraseQuery phraseQuery) {
        PhraseQuery newQuery = new PhraseQuery();
        Term[] termArray = phraseQuery.getTerms();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            Field field = Field.getByName(term.field());
            if (field != Field.CONTENTS) {
                return phraseQuery;
            }
            Term newTerm = Field.CONTENTS.createTerm(term.text().toLowerCase(Locale.ENGLISH));
            newQuery.add(newTerm);
            ++n2;
        }
        newQuery.setSlop(phraseQuery.getSlop());
        newQuery.setBoost(phraseQuery.getBoost());
        return newQuery;
    }
}

