/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing.querying;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.querying.QueryVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class FileNameSearcher
extends QueryVisitor {
    private Query originalQuery;

    @Override
    public void init(Query query) {
        this.originalQuery = query;
    }

    @Override
    public Query visit(TermQuery termQuery, Field field) {
        if (field == Field.CONTENTS && termQuery == this.originalQuery) {
            Term term = termQuery.getTerm();
            Term nameTerm = Field.NAME.createTerm(term.text());
            TermQuery nameQuery = new TermQuery(nameTerm);
            nameQuery.setBoost(termQuery.getBoost() * 2.0f);
            BooleanQuery boolQuery = new BooleanQuery();
            boolQuery.add((Query)nameQuery, BooleanClause.Occur.SHOULD);
            boolQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            return boolQuery;
        }
        return termQuery;
    }
}

