/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.InstaSearchPlugin;
import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.LengthNormSimilarity;
import it.unibz.instasearch.indexing.Searcher;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.Directory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SearchResultDoc {
    private Document doc;
    private int docId;
    private TermFreqVector termFreqVector;
    private float[] termScoreVector;
    private float score;
    private int matchCount;
    private Directory indexDir;

    public SearchResultDoc(Directory dir, Document doc, int docId, float score) {
        this.indexDir = dir;
        this.docId = docId;
        this.doc = doc;
        this.score = score;
        this.matchCount = 0;
    }

    private String getFieldValue(Field field) {
        return this.doc.get(field.toString());
    }

    public String getFilePath() {
        return this.getFieldValue(Field.FILE);
    }

    public String getFileName() {
        return this.getFieldValue(Field.NAME);
    }

    public String getFileExtension() {
        return this.getFieldValue(Field.EXT);
    }

    public boolean isInJar() {
        if (this.doc.getField(Field.JAR.toString()) == null) {
            return false;
        }
        String jarField = this.getFieldValue(Field.JAR);
        if ("<none>".equals(jarField)) {
            return false;
        }
        return jarField.toLowerCase(Locale.ENGLISH).endsWith(".jar");
    }

    public String getJarName() {
        if (this.isInJar()) {
            return this.getFieldValue(Field.JAR);
        }
        return null;
    }

    public IPath getProject() {
        return new Path(this.getFieldValue(Field.PROJ));
    }

    public String getProjectName() {
        return this.getProject().lastSegment();
    }

    private float[] getTermScoreVector() throws IOException {
        if (this.termScoreVector == null) {
            IndexReader reader = IndexReader.open((Directory)this.indexDir, (boolean)true);
            if (this.termFreqVector == null) {
                this.createFreqVect(reader);
            }
            this.termScoreVector = this.createTermScoreVector(this.termFreqVector, reader);
            reader.close();
        }
        return this.termScoreVector;
    }

    private TermFreqVector getTermFreqVector() throws IOException {
        if (this.termFreqVector == null) {
            IndexReader reader = IndexReader.open((Directory)this.indexDir, (boolean)true);
            this.createFreqVect(reader);
            reader.close();
        }
        return this.termFreqVector;
    }

    private void createFreqVect(IndexReader reader) throws IOException {
        this.termFreqVector = reader.getTermFreqVector(this.docId, Field.CONTENTS.toString());
    }

    public float[] getTermScoreVector(Collection<String> terms) throws IOException {
        float[] allTermScoreVect = this.getTermScoreVector();
        float[] termScoreVect = new float[allTermScoreVect.length];
        TermFreqVector freqVector = this.getTermFreqVector();
        for (String term : terms) {
            int idx = freqVector.indexOf(term);
            if (idx == -1) continue;
            termScoreVect[idx] = allTermScoreVect[idx];
        }
        return termScoreVect;
    }

    public double getTermScore(String term) throws IOException {
        float[] allTermScoreVect = this.getTermScoreVector();
        TermFreqVector freqVector = this.getTermFreqVector();
        if (freqVector == null) {
            return 0.0;
        }
        int idx = freqVector.indexOf(term);
        if (idx == -1) {
            return 0.0;
        }
        return allTermScoreVect[idx];
    }

    private float[] createTermScoreVector(TermFreqVector vect, IndexReader reader) throws IOException {
        if (vect == null) {
            return new float[0];
        }
        int[] termFrequencies = vect.getTermFrequencies();
        String[] terms = vect.getTerms();
        float[] scores = new float[terms.length];
        int numDocs = reader.maxDoc();
        LengthNormSimilarity sim = Searcher.SIMILARITY;
        int i = 0;
        while (i < terms.length) {
            float tfIdf;
            String termText = terms[i];
            Term term = new Term(Field.CONTENTS.toString(), termText);
            float termFreq = sim.tf(termFrequencies[i]);
            int docFreq = reader.docFreq(term);
            float idf = sim.idf(docFreq, numDocs);
            scores[i] = tfIdf = termFreq * idf;
            ++i;
        }
        return scores;
    }

    public IFile getFile() {
        if (this.isInJar()) {
            return null;
        }
        Path path = new Path(this.getFilePath());
        IWorkspaceRoot workspaceRoot = InstaSearchPlugin.getWorkspaceRoot();
        IFile file = workspaceRoot.getFile((IPath)path);
        if (file == null || file.getRawLocation() == null) {
            file = workspaceRoot.getFileForLocation((IPath)path);
        }
        return file;
    }

    public float getScore() {
        return this.score;
    }

    public Document getDoc() {
        return this.doc;
    }

    public int getDocId() {
        return this.docId;
    }

    public int getMatchCount() {
        return this.matchCount;
    }

    public void computeMatchCount(IndexReader reader, Collection<String> queryTerms) throws IOException {
        if (this.termFreqVector == null) {
            this.createFreqVect(reader);
        }
        if (this.termFreqVector == null) {
            return;
        }
        int[] freqs = this.termFreqVector.getTermFrequencies();
        int freqSum = 0;
        for (String term : queryTerms) {
            int idx = this.termFreqVector.indexOf(term);
            if (idx == -1) continue;
            freqSum += freqs[idx];
        }
        this.matchCount = freqSum;
    }

    public String toString() {
        return this.getFilePath();
    }
}

