/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.indexing.tokenizers.CamelCaseTokenizer;
import it.unibz.instasearch.indexing.tokenizers.DotSplitTokenizer;
import it.unibz.instasearch.indexing.tokenizers.WordSplitTokenizer;
import it.unibz.instasearch.indexing.tokenizers.standard.StandardTokenizer;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LengthFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public class FileAnalyzer
extends Analyzer {
    private int minWordLength;

    public FileAnalyzer(int minWordLength) {
        this.minWordLength = minWordLength;
    }

    public TokenStream tokenStream(Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new WordSplitTokenizer((TokenStream)result);
        result = new DotSplitTokenizer((TokenStream)result);
        result = new CamelCaseTokenizer((TokenStream)result);
        result = new LengthFilter((TokenStream)result, this.minWordLength, 128);
        result = new LowerCaseFilter((TokenStream)result);
        return result;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.tokenStream(reader);
    }

    public static class SysoFilter
    extends TokenFilter {
        private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);

        public SysoFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                System.out.println("TERM: " + this.termAtt.term());
                return true;
            }
            return false;
        }
    }
}

