/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.WillCloseWhenClosed;

public class OutputStreamXMLOutput
implements XMLOutput {
    private static final String OPENING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final Writer out;
    private int nestingLevel;
    private boolean newLine;
    private final String stylesheet;

    private static String getStylesheetCode(String stylesheet) {
        if (stylesheet == null) {
            return "";
        }
        return "<?xml-stylesheet type=\"text/xsl\" href=\"" + stylesheet + "\"?>\n";
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public OutputStreamXMLOutput(@WillCloseWhenClosed OutputStream os) {
        this(os, null);
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public OutputStreamXMLOutput(@WillCloseWhenClosed Writer writer) {
        this(writer, null);
    }

    public OutputStreamXMLOutput(@WillCloseWhenClosed OutputStream os, String stylesheet) {
        this.out = new OutputStreamWriter(os, Charset.forName("UTF-8"));
        this.nestingLevel = 0;
        this.newLine = true;
        this.stylesheet = stylesheet;
    }

    public OutputStreamXMLOutput(@WillCloseWhenClosed Writer writer, String stylesheet) {
        this.out = writer;
        this.nestingLevel = 0;
        this.newLine = true;
        this.stylesheet = stylesheet;
    }

    @Override
    public void beginDocument() throws IOException {
        this.out.write(OPENING);
        this.out.write(OutputStreamXMLOutput.getStylesheetCode(this.stylesheet));
        this.out.write("\n");
        this.newLine = true;
    }

    @Override
    public void openTag(String tagName) throws IOException {
        this.emitTag(tagName, false);
    }

    @Override
    public void openTag(String tagName, XMLAttributeList attributeList) throws IOException {
        this.emitTag(tagName, attributeList.toString(), false);
    }

    @Override
    public void openCloseTag(String tagName) throws IOException {
        this.emitTag(tagName, true);
    }

    @Override
    public void openCloseTag(String tagName, XMLAttributeList attributeList) throws IOException {
        this.emitTag(tagName, attributeList.toString(), true);
    }

    @Override
    public void startTag(String tagName) throws IOException {
        this.indent();
        ++this.nestingLevel;
        this.out.write("<" + tagName);
    }

    @Override
    public void addAttribute(String name, String value) throws IOException {
        this.out.write(32);
        this.out.write(name);
        this.out.write(61);
        this.out.write(34);
        this.out.write(XMLAttributeList.getQuotedAttributeValue(value));
        this.out.write(34);
    }

    @Override
    public void stopTag(boolean close) throws IOException {
        if (close) {
            this.out.write("/>\n");
            --this.nestingLevel;
            this.newLine = true;
        } else {
            this.out.write(">");
            this.newLine = false;
        }
    }

    private void emitTag(String tagName, boolean close) throws IOException {
        this.startTag(tagName);
        this.stopTag(close);
    }

    private void emitTag(String tagName, String attributes, boolean close) throws IOException {
        this.startTag(tagName);
        attributes = attributes.trim();
        if (attributes.length() > 0) {
            this.out.write(" ");
            this.out.write(attributes);
        }
        this.stopTag(close);
    }

    @Override
    public void closeTag(String tagName) throws IOException {
        --this.nestingLevel;
        if (this.newLine) {
            this.indent();
        }
        this.out.write("</" + tagName + ">\n");
        this.newLine = true;
    }

    @Override
    public void writeText(String text) throws IOException {
        this.out.write(Strings.escapeXml(text));
    }

    @Override
    public void writeCDATA(String cdata) throws IOException {
        assert (cdata.indexOf("]]") == -1);
        this.out.write("<![CDATA[");
        this.out.write(cdata);
        this.out.write("]]>");
        this.newLine = false;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    @DischargesObligation
    public void finish() throws IOException {
        this.out.close();
    }

    private void indent() throws IOException {
        if (!this.newLine) {
            this.out.write("\n");
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.out.write("  ");
        }
    }
}

