/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class UseEqualsResolution
extends BugResolution {
    private static final String EQUALS_METHOD_NAME = "equals";

    @Override
    protected boolean resolveBindings() {
        return true;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        InfixExpression[] stringEqualityChecks;
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)workingUnit);
        Assert.isNotNull((Object)bug);
        for (InfixExpression stringEqualityCheck : stringEqualityChecks = this.findStringEqualityChecks(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()))) {
            Expression replaceExpression;
            InfixExpression.Operator operator = stringEqualityCheck.getOperator();
            if (InfixExpression.Operator.EQUALS.equals(operator)) {
                replaceExpression = this.createEqualsExpression(rewrite, stringEqualityCheck);
            } else if (InfixExpression.Operator.NOT_EQUALS.equals(operator)) {
                replaceExpression = this.createNotEqualsExpression(rewrite, stringEqualityCheck);
            } else {
                throw new BugResolutionException("Illegal operator '" + operator + "' found.");
            }
            rewrite.replace((ASTNode)stringEqualityCheck, (ASTNode)replaceExpression, null);
        }
    }

    protected Expression createNotEqualsExpression(ASTRewrite rewrite, InfixExpression stringEqualityCheck) {
        Expression equalsExpression = this.createEqualsExpression(rewrite, stringEqualityCheck);
        AST ast = rewrite.getAST();
        PrefixExpression prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand(equalsExpression);
        return prefixExpression;
    }

    protected Expression createEqualsExpression(ASTRewrite rewrite, InfixExpression stringEqualityCheck) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)stringEqualityCheck);
        AST ast = rewrite.getAST();
        MethodInvocation equalsInvocation = ast.newMethodInvocation();
        Expression leftOperand = this.createLeftOperand(rewrite, stringEqualityCheck.getLeftOperand());
        Expression rightOperand = this.createRightOperand(rewrite, stringEqualityCheck.getRightOperand());
        equalsInvocation.setName(ast.newSimpleName(EQUALS_METHOD_NAME));
        equalsInvocation.setExpression(leftOperand);
        ListRewrite argumentsRewrite = rewrite.getListRewrite((ASTNode)equalsInvocation, MethodInvocation.ARGUMENTS_PROPERTY);
        argumentsRewrite.insertLast((ASTNode)rightOperand, null);
        return equalsInvocation;
    }

    private Expression createLeftOperand(ASTRewrite rewrite, Expression leftOperand) {
        Expression leftExp = (Expression)rewrite.createMoveTarget((ASTNode)leftOperand);
        if (leftOperand instanceof Name || leftOperand instanceof ParenthesizedExpression) {
            return leftExp;
        }
        AST ast = rewrite.getAST();
        ParenthesizedExpression parExp = ast.newParenthesizedExpression();
        parExp.setExpression(leftExp);
        return parExp;
    }

    private Expression createRightOperand(ASTRewrite rewrite, Expression rightOperand) {
        if (rightOperand instanceof ParenthesizedExpression) {
            return this.createRightOperand(rewrite, ((ParenthesizedExpression)rightOperand).getExpression());
        }
        return (Expression)rewrite.createMoveTarget((ASTNode)rightOperand);
    }

    private InfixExpression[] findStringEqualityChecks(ASTNode node) {
        StringEqualityCheckFinder finder = new StringEqualityCheckFinder();
        node.accept((ASTVisitor)finder);
        return finder.getStringEqualityChecks();
    }

    static boolean isStringEqualityCheck(InfixExpression infix) {
        InfixExpression.Operator op = infix.getOperator();
        return (InfixExpression.Operator.EQUALS.equals(op) || InfixExpression.Operator.NOT_EQUALS.equals(op)) && UseEqualsResolution.isStringOperand(infix.getLeftOperand()) && UseEqualsResolution.isStringOperand(infix.getRightOperand());
    }

    static boolean isStringOperand(Expression operand) {
        return !operand.resolveTypeBinding().isPrimitive();
    }

    static class StringEqualityCheckFinder
    extends ASTVisitor {
        private final Set<InfixExpression> objectEqualityChecks = new HashSet<InfixExpression>();

        StringEqualityCheckFinder() {
        }

        public boolean visit(InfixExpression node) {
            if (UseEqualsResolution.isStringEqualityCheck(node)) {
                this.objectEqualityChecks.add(node);
            }
            return true;
        }

        public InfixExpression[] getStringEqualityChecks() {
            return this.objectEqualityChecks.toArray(new InfixExpression[this.objectEqualityChecks.size()]);
        }
    }
}

