/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public class CreateMutableCloneResolution
extends BugResolution {
    @Override
    public boolean resolveBindings() {
        return true;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)workingUnit);
        Assert.isNotNull((Object)bug);
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        String fieldName = bug.getPrimaryField().getFieldName();
        SimpleName original = null;
        for (Statement stmt : method.getBody().statements()) {
            if (!(stmt instanceof ReturnStatement)) continue;
            Expression retEx = ((ReturnStatement)stmt).getExpression();
            if (retEx instanceof SimpleName && ((SimpleName)retEx).getIdentifier().equals(fieldName)) {
                original = (SimpleName)retEx;
                break;
            }
            if (!(retEx instanceof FieldAccess) || !this.isThisFieldAccess((FieldAccess)retEx, fieldName)) continue;
            original = ((FieldAccess)retEx).getName();
            break;
        }
        if (original == null) {
            throw new BugResolutionException("No original field found.");
        }
        MethodInvocation cloneInvoke = this.invokeClone(workingUnit, original);
        CastExpression castRet = workingUnit.getAST().newCastExpression();
        castRet.setExpression((Expression)cloneInvoke);
        Type retType = (Type)ASTNode.copySubtree((AST)castRet.getAST(), (ASTNode)method.getReturnType2());
        castRet.setType(retType);
        ConditionalExpression conditionalExpression = workingUnit.getAST().newConditionalExpression();
        conditionalExpression.setElseExpression((Expression)castRet);
        conditionalExpression.setThenExpression((Expression)workingUnit.getAST().newNullLiteral());
        InfixExpression nullTest = workingUnit.getAST().newInfixExpression();
        nullTest.setOperator(InfixExpression.Operator.EQUALS);
        nullTest.setRightOperand((Expression)workingUnit.getAST().newNullLiteral());
        SimpleName initialLoad = (SimpleName)ASTNode.copySubtree((AST)cloneInvoke.getAST(), (ASTNode)original);
        nullTest.setLeftOperand((Expression)initialLoad);
        conditionalExpression.setExpression((Expression)nullTest);
        rewrite.replace((ASTNode)original, (ASTNode)conditionalExpression, null);
    }

    private MethodInvocation invokeClone(CompilationUnit workingUnit, SimpleName original) {
        MethodInvocation cloneInvoke = workingUnit.getAST().newMethodInvocation();
        SimpleName cloneField = (SimpleName)ASTNode.copySubtree((AST)cloneInvoke.getAST(), (ASTNode)original);
        SimpleName cloneName = workingUnit.getAST().newSimpleName("clone");
        cloneInvoke.setExpression((Expression)cloneField);
        cloneInvoke.setName(cloneName);
        return cloneInvoke;
    }

    private boolean isThisFieldAccess(FieldAccess access, String fieldName) {
        return access.getExpression() instanceof ThisExpression && access.getName().getIdentifier().equals(fieldName);
    }
}

