/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionAssociations;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ConditionCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillClose;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.IMarkerResolution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BugResolutionLoader {
    private static final String BUG = "bug";
    private static final String BUG_TYPE = "type";
    private static final String RESOLUTION = "resolution";
    private static final String RESOLUTION_CLASS = "classname";
    private static final String ATTR = "attr";
    private static final String ATTR_NAME = "name";
    private DocumentBuilder builder;

    protected BugResolutionLoader(DocumentBuilder builder) {
        this.builder = builder;
    }

    public BugResolutionLoader() {
        this(null);
    }

    public BugResolutionAssociations loadBugResolutions(File xmlFile) {
        return this.loadBugResolutions(xmlFile, null);
    }

    public BugResolutionAssociations loadBugResolutions(File xmlFile, BugResolutionAssociations associations) {
        Document doc = this.parseDocument(xmlFile);
        if (doc == null) {
            return null;
        }
        return this.loadBugResolutions(doc, associations);
    }

    public BugResolutionAssociations loadBugResolutions() {
        InputStream is = BugResolutionLoader.class.getResourceAsStream("findbugs-resolutions.xml");
        if (is == null) {
            return null;
        }
        Document doc = this.parseDocument(is);
        if (doc == null) {
            return null;
        }
        return this.loadBugResolutions(doc, null);
    }

    public BugResolutionAssociations loadBugResolutions(Document document) {
        return this.loadBugResolutions(document, null);
    }

    public BugResolutionAssociations loadBugResolutions(Document fixesDoc, BugResolutionAssociations associations) {
        ConditionCheck.checkForNull(fixesDoc, "xml document with bug-resolutions");
        if (associations == null) {
            associations = new BugResolutionAssociations();
        }
        NodeList bugFixList = fixesDoc.getElementsByTagName(BUG);
        int length = bugFixList.getLength();
        for (int i = 0; i < length; ++i) {
            this.loadBugResolution((Element)bugFixList.item(i), associations);
        }
        return associations;
    }

    private void loadBugResolution(Element bugFixElement, BugResolutionAssociations associations) {
        String bugType = bugFixElement.getAttribute(BUG_TYPE);
        if (bugType == null) {
            FindbugsPlugin.getDefault().logError("No bug type found in BugResolution-Element.");
            return;
        }
        HashSet<Class<? extends IMarkerResolution>> resolutionClasses = new HashSet<Class<? extends IMarkerResolution>>();
        HashSet<IMarkerResolution> resolutions = new HashSet<IMarkerResolution>();
        NodeList resolutionNodes = bugFixElement.getElementsByTagName(RESOLUTION);
        int length = resolutionNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Class<? extends IMarkerResolution> resolutionClass = this.parseBugResolutionClass((Element)resolutionNodes.item(i));
            if (resolutionClass == null) continue;
            Map<String, String> attributes = this.parseAttributes((Element)resolutionNodes.item(i));
            if (attributes.isEmpty()) {
                resolutionClasses.add(resolutionClass);
                continue;
            }
            IMarkerResolution resolution = this.instantiateBugResolution(resolutionClass, attributes);
            if (resolution == null) continue;
            resolutions.add(resolution);
        }
        associations.registerBugResolutions(bugType, resolutionClasses);
        associations.addBugResolutions(bugType, resolutions);
    }

    @CheckForNull
    private IMarkerResolution instantiateBugResolution(Class<? extends IMarkerResolution> resolutionClass, Map<String, String> attributes) {
        try {
            IMarkerResolution resolution = resolutionClass.newInstance();
            this.loadAttributes(resolution, attributes);
            return resolution;
        }
        catch (InstantiationException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to instaniate BugResolution '" + resolutionClass.getSimpleName() + "'.");
            return null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private void loadAttributes(IMarkerResolution resolution, Map<String, String> attributes) {
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            String name = attr.getKey();
            String value = attr.getValue();
            this.loadAttribute(resolution, name, value);
        }
    }

    private void loadAttribute(IMarkerResolution resolution, String name, String value) {
        Class<?> typeClass = resolution.getClass();
        for (Method method : typeClass.getMethods()) {
            if (!this.isPropertySetterMethod(method, name)) continue;
            try {
                Class<?> paramType = method.getParameterTypes()[0];
                Object val = this.parseValue(value, paramType);
                method.invoke((Object)resolution, val);
                return;
            }
            catch (IllegalArgumentException e) {
                FindbugsPlugin.getDefault().logException(e, "Failed to parse attribute '" + name + " = " + value + "'.");
            }
            catch (InvocationTargetException e) {
                FindbugsPlugin.getDefault().logException(e, "Failed to load attribute '" + name + "' = " + value + "'.");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private boolean isPropertySetterMethod(Method method, String propertyName) {
        return method.getParameterTypes().length == 1 && method.getName().startsWith("set") && method.getName().length() > 3 && method.getName().substring(3).equalsIgnoreCase(propertyName);
    }

    private <T> Object parseValue(String value, Class<T> type) throws IllegalArgumentException {
        if (String.class == type) {
            return value;
        }
        if (Boolean.TYPE == type || Boolean.class == type) {
            return Boolean.valueOf(value);
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE == type || Long.class == type) {
            return Long.valueOf(value);
        }
        if (Float.TYPE == type || Float.class == type) {
            return Float.valueOf(value);
        }
        if (Double.TYPE == type || Double.class == type) {
            return Double.valueOf(value);
        }
        throw new IllegalArgumentException("Unknown value type '" + type.getName() + "'.");
    }

    @CheckForNull
    private Class<? extends IMarkerResolution> parseBugResolutionClass(Element resolutionElement) {
        String className = resolutionElement.getAttribute(RESOLUTION_CLASS);
        if (className == null) {
            FindbugsPlugin.getDefault().logWarning("Missing a classname in the resolution element.");
            return null;
        }
        try {
            Class<?> resolutionClass = Class.forName(className);
            if (IMarkerResolution.class.isAssignableFrom(resolutionClass)) {
                return resolutionClass.asSubclass(IMarkerResolution.class);
            }
            FindbugsPlugin.getDefault().logError("BugResolution '" + className + "' not a IMarkerResolution");
        }
        catch (ClassNotFoundException e) {
            FindbugsPlugin.getDefault().logException(e, "BugResolution '" + className + "' not found.");
        }
        return null;
    }

    private Map<String, String> parseAttributes(Element resolutionElement) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        try {
            NodeList attrList = resolutionElement.getElementsByTagName(ATTR);
            int length = attrList.getLength();
            for (int i = 0; i < length; ++i) {
                Element attrElement = (Element)attrList.item(i);
                String name = attrElement.getAttribute(ATTR_NAME);
                String value = attrElement.getTextContent();
                if (name == null || value == null) continue;
                attributes.put(name, value);
            }
        }
        catch (RuntimeException e) {
            AnalysisContext.logError("Error parsing attributes", e);
        }
        return attributes;
    }

    @CheckForNull
    private Document parseDocument(File xmlFile) {
        if (!xmlFile.exists()) {
            FindbugsPlugin.getDefault().logError("Need file '" + xmlFile.getPath() + "' but it doesn't exist");
            return null;
        }
        if (!xmlFile.canRead()) {
            FindbugsPlugin.getDefault().logError("Need file '" + xmlFile.getPath() + "' but it isn't readable");
            return null;
        }
        try {
            if (this.builder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.builder = factory.newDocumentBuilder();
            }
            return this.builder.parse(xmlFile);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to parse xml file '" + xmlFile.getPath() + "'.");
            return null;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to read the xml file '" + xmlFile.getPath() + "'.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private Document parseDocument(@WillClose InputStream is) {
        try {
            Object factory;
            if (this.builder == null) {
                factory = DocumentBuilderFactory.newInstance();
                this.builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            }
            factory = this.builder.parse(is);
            return factory;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to parse xml file");
            Document document = null;
            return document;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to read the xml file");
            Document document = null;
            return document;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }
}

