/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class WrongMapIterator
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugAccumulator bugAccumulator;
    private static final int SAW_NOTHING = 0;
    private static final int SAW_MAP_LOAD1 = 1;
    private static final int SAW_KEYSET = 2;
    private static final int SAW_KEYSET_STORE = 3;
    private static final int SAW_ITERATOR = 4;
    private static final int SAW_ITERATOR_STORE = 5;
    private static final int SAW_ITERATOR_LOAD = 6;
    private static final int SAW_NEXT = 7;
    private static final int SAW_CHECKCAST_ON_NEXT = 8;
    private static final int SAW_KEY_STORE = 9;
    private static final int NEED_KEYSET_LOAD = 10;
    private static final int SAW_MAP_LOAD2 = 11;
    private static final int SAW_KEY_LOAD = 12;
    private int state;
    private int loadedRegister;
    private int mapRegister;
    private int keySetRegister;
    private int iteratorRegister;
    private int keyRegister;

    public WrongMapIterator(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Method obj) {
        this.state = 0;
        this.loadedRegister = -1;
        this.mapRegister = -1;
        this.keySetRegister = -1;
        this.iteratorRegister = -1;
        this.keyRegister = -1;
    }

    @Override
    public void visit(Code code) {
        super.visit(code);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private static boolean implementsMap(ClassDescriptor d) {
        while (d != null) {
            try {
                if ("java.util.Map".equals(d.getDottedClassName())) {
                    return true;
                }
                XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, d);
                ClassDescriptor[] is = classNameAndInfo.getInterfaceDescriptorList();
                d = classNameAndInfo.getSuperclassDescriptor();
                for (ClassDescriptor i : is) {
                    if (!"java.util.Map".equals(i.getDottedClassName())) continue;
                    return true;
                }
            }
            catch (CheckedAnalysisException e) {
                d = null;
            }
        }
        return false;
    }

    @Override
    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                this.loadedRegister = this.getLoadStoreRegister(seen, true);
                if (this.loadedRegister < 0) break;
                this.state = 1;
                break;
            }
            case 1: {
                if ((seen == 185 || seen == 182) && "keySet".equals(this.getNameConstantOperand()) && "()Ljava/util/Set;".equals(this.getSigConstantOperand()) && WrongMapIterator.implementsMap(this.getClassDescriptorOperand())) {
                    this.mapRegister = this.loadedRegister;
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                this.keySetRegister = this.getLoadStoreRegister(seen, false);
                if (this.keySetRegister >= 0) {
                    this.state = 3;
                    break;
                }
                if (seen == 185 && "iterator".equals(this.getNameConstantOperand()) && "()Ljava/util/Iterator;".equals(this.getSigConstantOperand())) {
                    this.state = 4;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (seen == 185 && "iterator".equals(this.getNameConstantOperand()) && "()Ljava/util/Iterator;".equals(this.getSigConstantOperand())) {
                    this.state = 4;
                    break;
                }
                this.state = 10;
                break;
            }
            case 10: {
                this.loadedRegister = this.getLoadStoreRegister(seen, true);
                if (this.loadedRegister != this.iteratorRegister) break;
                this.state = 4;
                break;
            }
            case 4: {
                this.iteratorRegister = this.getLoadStoreRegister(seen, false);
                if (this.iteratorRegister >= 0) {
                    this.state = 5;
                    break;
                }
                this.state = 0;
                break;
            }
            case 5: {
                this.loadedRegister = this.getLoadStoreRegister(seen, true);
                if (this.loadedRegister != this.iteratorRegister) break;
                this.state = 6;
                break;
            }
            case 6: {
                if (seen == 185 && "next".equals(this.getNameConstantOperand()) && "()Ljava/lang/Object;".equals(this.getSigConstantOperand())) {
                    this.state = 7;
                    break;
                }
                this.state = 5;
                break;
            }
            case 7: {
                if (seen == 192) {
                    this.state = 8;
                    break;
                }
                this.keyRegister = this.getLoadStoreRegister(seen, false);
                if (this.keyRegister >= 0) {
                    this.state = 9;
                    break;
                }
                this.state = 0;
                break;
            }
            case 8: {
                this.keyRegister = this.getLoadStoreRegister(seen, false);
                if (this.keyRegister < 0) break;
                this.state = 9;
                break;
            }
            case 9: {
                this.loadedRegister = this.getLoadStoreRegister(seen, true);
                if (this.loadedRegister != this.mapRegister) break;
                this.state = 11;
                break;
            }
            case 11: {
                this.loadedRegister = this.getLoadStoreRegister(seen, true);
                if (this.loadedRegister == this.keyRegister) {
                    this.state = 12;
                    break;
                }
                this.state = 9;
                break;
            }
            case 12: {
                if (seen != 185 && seen != 182 || !"get".equals(this.getNameConstantOperand()) || !"(Ljava/lang/Object;)Ljava/lang/Object;".equals(this.getSigConstantOperand())) break;
                MethodAnnotation ma = MethodAnnotation.fromVisitedMethod(this);
                this.bugAccumulator.accumulateBug(new BugInstance(this, "WMI_WRONG_MAP_ITERATOR", 2).addClass(this).addMethod(ma), this);
                this.state = 0;
                break;
            }
        }
    }

    private int getLoadStoreRegister(int seen, boolean doLoad) {
        switch (seen) {
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (!doLoad) break;
                return seen - 42;
            }
            case 25: {
                if (!doLoad) break;
                return this.getRegisterOperand();
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                if (doLoad) break;
                return seen - 75;
            }
            case 58: {
                if (doLoad) break;
                return this.getRegisterOperand();
            }
        }
        return -1;
    }
}

