/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class InefficientMemberAccess
extends BytecodeScanningDetector
implements StatelessDetector {
    public static final String ACCESS_PREFIX = "access$";
    private final BugReporter bugReporter;
    private String clsName;

    public InefficientMemberAccess(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        this.clsName = cls.getClassName();
        if (this.clsName.indexOf(36) >= 0) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 184) {
            String methodName = this.getNameConstantOperand();
            if (!methodName.startsWith(ACCESS_PREFIX)) {
                return;
            }
            String methodSig = this.getSigConstantOperand();
            Type[] argTypes = Type.getArgumentTypes((String)methodSig);
            if (argTypes.length < 1 || argTypes.length > 2) {
                return;
            }
            String parCls = argTypes[0].getSignature();
            if (parCls.length() < 3) {
                return;
            }
            if (!(parCls = parCls.substring(1, parCls.length() - 1)).equals(this.getClassConstantOperand())) {
                return;
            }
            if (argTypes.length == 2 && !argTypes[1].getSignature().equals(Type.getReturnType((String)methodSig).getSignature())) {
                return;
            }
            InnerClassAccess access = null;
            try {
                String dottedClassConstantOperand = this.getDottedClassConstantOperand();
                access = AnalysisContext.currentAnalysisContext().getInnerClassAccessMap().getInnerClassAccess(dottedClassConstantOperand, methodName);
                if (access != null) {
                    if (!access.getField().getClassName().equals(dottedClassConstantOperand)) {
                        return;
                    }
                    if (access.getField().isSynthetic()) {
                        return;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            BugInstance bug = new BugInstance(this, "IMA_INEFFICIENT_MEMBER_ACCESS", 3).addClassAndMethod(this).addSourceLine(this);
            if (access != null) {
                bug.addField(access.getField());
            }
            this.bugReporter.reportBug(bug);
        }
    }
}

