/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.detect.DumbMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class DoInsideDoPrivileged
extends BytecodeScanningDetector {
    BugAccumulator bugAccumulator;
    boolean isDoPrivileged = false;

    public DoInsideDoPrivileged(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        this.isDoPrivileged = Subtypes2.instanceOf(this.getDottedClassName(), "java.security.PrivilegedAction") || Subtypes2.instanceOf(this.getDottedClassName(), "java.security.PrivilegedExceptionAction");
    }

    @Override
    public void visit(Code obj) {
        if (this.isDoPrivileged && this.getMethodName().equals("run")) {
            return;
        }
        if (this.getMethod().isPrivate()) {
            return;
        }
        if (DumbMethods.isTestMethod(this.getMethod())) {
            return;
        }
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        String classOfConstructedClass;
        String className;
        if (seen == 182 && this.getNameConstantOperand().equals("setAccessible") && ((className = this.getDottedClassConstantOperand()).equals("java.lang.reflect.Field") || className.equals("java.lang.reflect.Method"))) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DP_DO_INSIDE_DO_PRIVILEGED", 3).addClassAndMethod(this).addCalledMethod(this), this);
        }
        if (!(seen != 187 || !Subtypes2.instanceOf(classOfConstructedClass = this.getDottedClassConstantOperand(), "java.lang.ClassLoader") || this.getMethodName().equals("main") && this.getMethodSig().equals("([Ljava/lang/String;)V") && this.getMethod().isStatic())) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED", 2).addClassAndMethod(this).addClass(classOfConstructedClass), this);
        }
    }
}

