/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.interproc;

import java.util.BitSet;
import java.util.Iterator;

public class ParameterProperty {
    public static final int MAX_PARAMS = 32;
    private int bits;

    public ParameterProperty() {
        this.bits = 0;
    }

    public ParameterProperty(int bits) {
        this.bits = bits;
    }

    public int getParamsWithProperty() {
        return this.bits;
    }

    public Iterable<Integer> iterable() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    int nextInt = 0;
                    {
                        this.advanceNextInt();
                    }

                    private void advanceNextInt() {
                        while (!ParameterProperty.this.hasProperty(this.nextInt) && this.nextInt < 32) {
                            ++this.nextInt;
                        }
                        if (this.nextInt >= 32) {
                            this.nextInt = -1;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextInt >= 0;
                    }

                    @Override
                    public Integer next() {
                        int result = this.nextInt++;
                        this.advanceNextInt();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void setParamsWithProperty(int nonNullParamSet) {
        this.bits = nonNullParamSet;
    }

    public void setParamsWithProperty(BitSet nonNullSet) {
        for (int i = 0; i < 32; ++i) {
            this.setParamWithProperty(i, nonNullSet.get(i));
        }
    }

    public void setParamWithProperty(int param, boolean hasProperty) {
        if (param < 0 || param > 31) {
            return;
        }
        this.bits = hasProperty ? (this.bits |= 1 << param) : (this.bits &= ~(1 << param));
    }

    public boolean hasProperty(int param) {
        if (param < 0 || param > 31) {
            return false;
        }
        return (this.bits & 1 << param) != 0;
    }

    public BitSet getMatchingParameters(BitSet nullArgSet) {
        BitSet result = new BitSet();
        for (int i = 0; i < 32; ++i) {
            result.set(i, nullArgSet.get(i) && this.hasProperty(i));
        }
        return result;
    }

    public BitSet getAsBitSet() {
        BitSet result = new BitSet();
        if (this.isEmpty()) {
            return result;
        }
        for (int i = 0; i < 32; ++i) {
            result.set(i, this.hasProperty(i));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        for (int i = 0; i < 32; ++i) {
            if (!this.hasProperty(i)) continue;
            if (buf.length() > 1) {
                buf.append(',');
            }
            buf.append(i);
        }
        buf.append('}');
        return buf.toString();
    }

    public void intersectWith(ParameterProperty targetDerefParamSet) {
        this.bits &= targetDerefParamSet.bits;
    }

    public void copyFrom(ParameterProperty other) {
        this.bits = other.bits;
    }
}

