/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class GenericObjectType
extends ObjectType {
    final List<? extends ReferenceType> parameters;
    @CheckForNull
    final String variable;
    @CheckForNull
    final ReferenceType extension;

    public ReferenceType produce() {
        return this.getTypeCategory().produce(this);
    }

    public int hashCode() {
        return 13 * super.hashCode() + 9 * Util.nullSafeHashcode(this.parameters) + 7 * Util.nullSafeHashcode(this.variable) + Util.nullSafeHashcode(this.extension);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenericObjectType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericObjectType that = (GenericObjectType)((Object)o);
        return Util.nullSafeEquals(this.parameters, that.parameters) && Util.nullSafeEquals(this.variable, that.variable) && Util.nullSafeEquals(this.extension, that.extension);
    }

    public Type getUpperBound() {
        if ("+".equals(this.variable)) {
            return this.extension;
        }
        return this;
    }

    public Type getExtension() {
        return this.extension;
    }

    public String getVariable() {
        return this.variable;
    }

    public GenericUtilities.TypeCategory getTypeCategory() {
        if (this.hasParameters() && this.variable == null && this.extension == null) {
            return GenericUtilities.TypeCategory.PARAMETERIZED;
        }
        if (!this.hasParameters() && this.variable != null && this.extension == null) {
            if (this.variable.equals("*")) {
                return GenericUtilities.TypeCategory.WILDCARD;
            }
            return GenericUtilities.TypeCategory.TYPE_VARIABLE;
        }
        if (!this.hasParameters() && this.variable != null && this.extension != null) {
            if (this.variable.equals("+")) {
                return GenericUtilities.TypeCategory.WILDCARD_EXTENDS;
            }
            if (this.variable.equals("-")) {
                return GenericUtilities.TypeCategory.WILDCARD_SUPER;
            }
        }
        throw new IllegalStateException("The Generic Object Type is badly initialized");
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public int getNumParameters() {
        return this.parameters != null ? this.parameters.size() : 0;
    }

    public ReferenceType getParameterAt(int index) {
        if (index < this.getNumParameters()) {
            return this.parameters.get(index);
        }
        throw new IndexOutOfBoundsException("The index " + index + " is too large for " + (Object)((Object)this));
    }

    @CheckForNull
    public List<? extends ReferenceType> getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return Collections.unmodifiableList(this.parameters);
    }

    GenericObjectType(@Nonnull String variable) {
        this(variable, (ReferenceType)null);
    }

    GenericObjectType(@Nonnull String wildcard, @CheckForNull ReferenceType extension) {
        super(DescriptorFactory.canonicalizeString(Type.OBJECT.getClassName()));
        this.variable = DescriptorFactory.canonicalizeString(wildcard);
        this.extension = extension;
        this.parameters = null;
    }

    GenericObjectType(@DottedClassName String class_name, List<? extends ReferenceType> parameters) {
        super(DescriptorFactory.canonicalizeString(class_name));
        this.variable = null;
        this.extension = null;
        if (parameters == null || parameters.size() == 0) {
            throw new IllegalStateException("argument 'parameters' must contain at least 1 parameter");
        }
        this.parameters = parameters;
    }

    public ObjectType getObjectType() {
        String cName = ClassName.fromFieldSignature(this.getSignature());
        if (cName == null) {
            throw new IllegalStateException("Can't provide ObjectType for " + (Object)((Object)this));
        }
        String c = ClassName.toDottedClassName(cName);
        return ObjectTypeFactory.getInstance(c);
    }

    public String toString(boolean includeGenerics) {
        return this.getTypeCategory().asString(this);
    }

    public String toString() {
        return this.getTypeCategory().asString(this);
    }

    public String toPlainString() {
        return super.toString();
    }

    public String getGenericParametersAsString() {
        if (this.getTypeCategory() != GenericUtilities.TypeCategory.PARAMETERIZED) {
            throw new IllegalStateException(this.toString() + " doesn't have generic parameters");
        }
        String baseStringValue = super.toString();
        String fullStringValue = this.toString();
        return fullStringValue.substring(baseStringValue.length());
    }
}

