/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Plugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FilterBugsDialog
extends SelectionDialog {
    private final Set<BugPattern> allowedPatterns;
    private final Set<BugPattern> preSelectedPatterns;
    private final Set<BugCode> preSelectedTypes;
    private final Set<BugCode> allowedTypes;
    private final Map<BugCode, Set<BugPattern>> codeToPattern = new HashMap<BugCode, Set<BugPattern>>();
    private final Map<BugPattern, Set<DetectorFactory>> patternToFactory = new HashMap<BugPattern, Set<DetectorFactory>>();
    private final Map<BugPattern, Set<Plugin>> patternToPlugin = new HashMap<BugPattern, Set<Plugin>>();
    private ContainerCheckedTreeViewer checkList;
    private TextPresentation presentation;
    private StyledText htmlControl;
    private DefaultInformationControl.IInformationPresenterExtension presenter;
    private Text selectedIds;
    private Object[] checkedElements;
    private final TreeContentProvider contentProvider;
    private final TreeLabelProvider labelProvider;
    private String selectedAsText;

    public FilterBugsDialog(Shell parentShell, Set<BugPattern> filteredPatterns, Set<BugCode> filteredTypes) {
        super(parentShell);
        this.allowedPatterns = FindbugsPlugin.getKnownPatterns();
        this.allowedTypes = FindbugsPlugin.getKnownPatternTypes();
        this.preSelectedPatterns = filteredPatterns;
        this.preSelectedTypes = filteredTypes;
        this.contentProvider = new TreeContentProvider();
        this.labelProvider = new TreeLabelProvider();
        this.initMaps();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private void initMaps() {
        BugCode bugCode;
        for (BugPattern pattern : this.allowedPatterns) {
            bugCode = DetectorFactoryCollection.instance().getBugCode(pattern.getAbbrev());
            this.getPatterns(bugCode).add(pattern);
        }
        Iterator<BugPattern> patterns = this.preSelectedPatterns.iterator();
        while (patterns.hasNext()) {
            BugPattern pattern;
            pattern = patterns.next();
            bugCode = DetectorFactoryCollection.instance().getBugCode(pattern.getAbbrev());
            if (!this.preSelectedTypes.contains(bugCode)) continue;
            patterns.remove();
        }
        ArrayList<Comparable<BugCode>> merged = new ArrayList<Comparable<BugCode>>();
        merged.addAll(this.preSelectedTypes);
        merged.addAll(this.preSelectedPatterns);
        for (BugCode bugCode2 : this.preSelectedTypes) {
            this.preSelectedPatterns.addAll(this.getPatterns(bugCode2));
        }
        this.checkedElements = merged.toArray();
        this.sortCheckedElements();
        this.initDetectorMaps();
    }

    private void initDetectorMaps() {
        Iterator<DetectorFactory> iterator = DetectorFactoryCollection.instance().factoryIterator();
        while (iterator.hasNext()) {
            DetectorFactory factory = iterator.next();
            Set<BugPattern> patterns = factory.getReportedBugPatterns();
            for (BugPattern pattern : patterns) {
                Set<DetectorFactory> set = this.patternToFactory.get(pattern);
                if (set == null) {
                    set = new TreeSet<DetectorFactory>(new Comparator<DetectorFactory>(){

                        @Override
                        public int compare(DetectorFactory f1, DetectorFactory f2) {
                            return f1.getFullName().compareTo(f2.getFullName());
                        }
                    });
                    this.patternToFactory.put(pattern, set);
                }
                set.add(factory);
                Set<Plugin> pset = this.patternToPlugin.get(pattern);
                if (pset == null) {
                    pset = new TreeSet<Plugin>(new Comparator<Plugin>(){

                        @Override
                        public int compare(Plugin f1, Plugin f2) {
                            return f1.getPluginId().compareTo(f2.getPluginId());
                        }
                    });
                    this.patternToPlugin.put(pattern, pset);
                }
                pset.add(factory.getPlugin());
            }
        }
    }

    public boolean close() {
        String text = this.selectedIds.getText();
        String computed = this.getSelectedIds();
        this.selectedAsText = text.length() > 0 && !computed.equals(text) ? text : computed;
        return super.close();
    }

    public String getSelectedIds() {
        if (this.selectedAsText != null) {
            return this.selectedAsText;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : this.checkedElements) {
            if (this.checkList.getGrayed(object)) continue;
            if (object instanceof BugCode) {
                BugCode bugCode = (BugCode)object;
                sb.append(bugCode.getAbbrev()).append(", ");
                continue;
            }
            if (!(object instanceof BugPattern)) continue;
            BugPattern pattern = (BugPattern)object;
            sb.append(pattern.getType()).append(", ");
        }
        if (sb.length() > 2 && sb.indexOf(", ", sb.length() - 2) > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    protected Control createDialogArea(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 200;
        layoutData.minimumWidth = 200;
        layoutData.heightHint = 400;
        layoutData.widthHint = 500;
        layoutData.verticalIndent = 3;
        layoutData.horizontalIndent = 3;
        sash.setLayoutData((Object)layoutData);
        Group treeAndButtons = this.createGroup((Composite)sash, "Available pattern types and patterns");
        treeAndButtons.setLayout((Layout)new GridLayout());
        treeAndButtons.setLayoutData((Object)new GridData(1808));
        final PatternFilteredTree tree = new PatternFilteredTree((Composite)treeAndButtons, 2836, new PatternFilter());
        tree.setLayoutData(new GridData(1808));
        Composite buttons = new Composite((Composite)treeAndButtons, 0);
        buttons.setLayout((Layout)new GridLayout(3, true));
        buttons.setLayoutData((Object)new GridData(768));
        Button button1 = new Button(buttons, 8);
        button1.setLayoutData((Object)new GridData(768));
        button1.setText("Select All");
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterBugsDialog.this.checkList.setAllChecked(true);
                FilterBugsDialog.access$502(FilterBugsDialog.this, FilterBugsDialog.this.allowedTypes.toArray());
                FilterBugsDialog.this.updateTextIds();
            }
        });
        Button button2 = new Button(buttons, 8);
        button2.setLayoutData((Object)new GridData(768));
        button2.setText("Deselect All");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterBugsDialog.this.checkList.setAllChecked(false);
                FilterBugsDialog.access$502(FilterBugsDialog.this, new Object[0]);
                FilterBugsDialog.this.updateTextIds();
            }
        });
        SashForm rightPane = new SashForm((Composite)sash, 512);
        rightPane.setLayoutData((Object)new GridData(1808));
        Group group1 = this.createGroup((Composite)rightPane, "Description");
        this.htmlControl = new StyledText((Composite)group1, 2888);
        this.presentation = new TextPresentation();
        this.htmlControl.setLayoutData((Object)new GridData(1808));
        this.presenter = new HTMLTextPresenter(false);
        Group group2 = this.createGroup((Composite)rightPane, "Filtered pattern types and patterns");
        this.selectedIds = new Text((Composite)group2, 2880);
        this.selectedIds.setLayoutData((Object)new GridData(1808));
        this.updateTextIds();
        return sash;
    }

    private void toggleCheckedGroup(boolean on) {
        if (on) {
            Object[] elements = this.checkList.getVisibleExpandedElements();
            List<Object> list = Arrays.asList(this.checkedElements);
            for (Object object : elements) {
                if (list.contains(object)) continue;
                this.elementChecked(object, on);
            }
        } else {
            Object[] elements = this.checkList.getVisibleExpandedElements();
            List<Object> list = Arrays.asList(this.checkedElements);
            for (Object object : elements) {
                Object parent = this.contentProvider.getParent(object);
                if (!list.contains(object) && !list.contains(parent)) continue;
                this.elementChecked(object, on);
            }
        }
        this.sortCheckedElements();
        this.checkList.setCheckedElements(this.checkedElements);
    }

    private Group createGroup(Composite composite, String name) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(name);
        return group;
    }

    private ContainerCheckedTreeViewer createTree(Composite parent, int style) {
        final ContainerCheckedTreeViewer viewer = new ContainerCheckedTreeViewer(parent, style | 4 | 0x800 | 0x200 | 0x100 | 0x10){

            public void refresh(boolean updateLabels) {
                super.refresh(updateLabels);
                this.setCheckedElements(FilterBugsDialog.this.checkedElements);
            }
        };
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setInput(this.allowedTypes);
        Object[] preselected = this.getPreselected();
        viewer.setCheckedElements(preselected);
        viewer.addPostSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener());
        viewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FilterBugsDialog.this.updateDescription((IStructuredSelection)viewer.getSelection());
            }
        });
        viewer.addCheckStateListener((ICheckStateListener)new TreeCheckStateListener());
        return viewer;
    }

    private Object[] getPreselected() {
        ArrayList<BugPattern> all = new ArrayList<BugPattern>(this.preSelectedPatterns);
        all.addAll(this.preSelectedTypes);
        return all.toArray();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings dialogSettings = FindbugsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection("FilterBugDialog");
        if (section == null) {
            dialogSettings.addNewSection("FilterBugDialog");
        }
        return section;
    }

    private Set<BugPattern> getPatterns(BugCode bugCode) {
        Set<BugPattern> set = this.codeToPattern.get(bugCode);
        if (set != null) {
            return set;
        }
        set = new HashSet<BugPattern>();
        this.codeToPattern.put(bugCode, set);
        return set;
    }

    private void updateTextIds() {
        this.selectedIds.setText(this.getSelectedIds());
        int selTypes = this.checkedElements.length;
        for (Object object : this.checkedElements) {
            if (!(object instanceof BugPattern)) continue;
            --selTypes;
        }
        this.selectedIds.setToolTipText("Available types: " + this.allowedTypes.size() + ", available patterns: " + this.allowedPatterns.size() + ", selected types: " + selTypes + ", patterns: " + (this.checkedElements.length - selTypes));
    }

    private void toggleElement(boolean on, Object element, Set<Object> set) {
        if (on) {
            set.add(element);
        } else {
            set.remove(element);
        }
    }

    protected void elementChecked(Object element, boolean checked) {
        HashSet<Object> selected = new HashSet<Object>();
        selected.addAll(Arrays.asList(this.checkedElements));
        this.toggleElement(checked, element, selected);
        if (element instanceof BugCode) {
            Set<BugPattern> children = this.getPatterns((BugCode)element);
            selected.removeAll(children);
        } else {
            Object parentEl = this.contentProvider.getParent(element);
            if (parentEl instanceof BugCode) {
                Set<BugPattern> children = this.getPatterns((BugCode)parentEl);
                boolean all = true;
                for (BugPattern object : children) {
                    if (object == element || checked == this.checkList.getChecked((Object)object)) continue;
                    all = false;
                    break;
                }
                if (all) {
                    this.toggleElement(checked, parentEl, selected);
                    selected.removeAll(children);
                } else if (this.checkList.getChecked(parentEl)) {
                    this.toggleElement(false, parentEl, selected);
                    for (BugPattern object : children) {
                        this.toggleElement(this.checkList.getChecked((Object)object), object, selected);
                    }
                }
            }
        }
        this.checkedElements = selected.toArray();
        this.sortCheckedElements();
    }

    private void sortCheckedElements() {
        Arrays.sort(this.checkedElements, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String text1 = FilterBugsDialog.this.labelProvider.getText(o1);
                String text2 = FilterBugsDialog.this.labelProvider.getText(o2);
                if (text1 == null) {
                    return -1;
                }
                if (text2 == null) {
                    return 1;
                }
                return text1.compareTo(text2);
            }
        });
    }

    private void updateDescription(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        String txt = " ";
        if (element instanceof BugPattern) {
            BugPattern pattern = (BugPattern)element;
            txt = this.getPatternDescription(pattern);
        } else if (element instanceof BugCode) {
            BugCode code = (BugCode)element;
            txt = this.getPatternTypeDescription(code);
        }
        Rectangle size = this.htmlControl.getClientArea();
        txt = this.presenter.updatePresentation((Drawable)this.getShell().getDisplay(), txt, this.presentation, size.width, size.height);
        this.htmlControl.setText(txt);
    }

    private String getPatternDescription(BugPattern pattern) {
        StringBuilder sb = new StringBuilder(pattern.getDetailText());
        Set<Plugin> plugins = this.patternToPlugin.get(pattern);
        for (Plugin plugin : plugins) {
            sb.append("<p>");
            this.appendPluginDescription(sb, plugin);
        }
        return sb.toString();
    }

    private void appendPluginDescription(StringBuilder sb, Plugin plugin) {
        sb.append("<p>Contributed by plugin: ").append(plugin.getPluginId());
        sb.append("<p>Provider: ").append(plugin.getProvider());
        String website = plugin.getWebsite();
        if (website != null && website.length() > 0) {
            sb.append(" (").append(website).append(")");
        }
    }

    private String getPatternTypeDescription(BugCode code) {
        StringBuilder sb = new StringBuilder(code.getDescription());
        sb.append("<p><br>Patterns:<br>");
        Set<BugPattern> patterns = this.getPatterns(code);
        for (BugPattern bugPattern : patterns) {
            sb.append(bugPattern.getType()).append("<br>");
        }
        TreeSet<DetectorFactory> allFactories = new TreeSet<DetectorFactory>(new Comparator<DetectorFactory>(){

            @Override
            public int compare(DetectorFactory f1, DetectorFactory f2) {
                return f1.getFullName().compareTo(f2.getFullName());
            }
        });
        for (BugPattern bugPattern : patterns) {
            Set<DetectorFactory> set = this.patternToFactory.get(bugPattern);
            if (set != null) {
                allFactories.addAll(set);
                continue;
            }
            if (!this.shouldReportMissing(bugPattern)) continue;
            FindbugsPlugin.getDefault().logError("Pattern not reported by any detector, but defined in findbugs.xml: " + bugPattern);
        }
        sb.append("<p>Reported by:<br>");
        for (DetectorFactory factory : allFactories) {
            sb.append(factory.getFullName());
            this.appendPluginDescription(sb, factory.getPlugin());
            sb.append("<p><p>");
        }
        return sb.toString();
    }

    private boolean shouldReportMissing(BugPattern bugPattern) {
        return !bugPattern.isDeprecated() && !"UNKNOWN".equals(bugPattern.getType()) && !"EXPERIMENTAL".equals(bugPattern.getCategory()) && !"SKIPPED_CLASS_TOO_BIG".equals(bugPattern.getType());
    }

    static /* synthetic */ Object[] access$502(FilterBugsDialog x0, Object[] x1) {
        x0.checkedElements = x1;
        return x1;
    }

    class PatternFilteredTree
    extends FilteredTree {
        PatternFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent1, int style) {
            FilterBugsDialog.this.checkList = FilterBugsDialog.this.createTree(parent1, style);
            return FilterBugsDialog.this.checkList;
        }

        protected void clearText() {
            FilterBugsDialog.this.checkList.setCheckedElements(FilterBugsDialog.this.checkedElements);
            FilterBugsDialog.this.checkList.collapseAll();
            super.clearText();
        }

        public boolean isFiltering() {
            String filterString = this.getFilterString();
            boolean yes = filterString != null && filterString.length() > 0 && !filterString.equals(this.getInitialText());
            return yes;
        }
    }

    private static final class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof BugPattern) {
                BugPattern pattern = (BugPattern)element;
                return pattern.getType() + " (" + pattern.getCategory().toLowerCase() + ")";
            }
            if (element instanceof BugCode) {
                BugCode code = (BugCode)element;
                return code.getAbbrev();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof BugCode) {
                Set children = FilterBugsDialog.this.getPatterns((BugCode)element);
                Object[] array = children.toArray();
                Arrays.sort(array);
                return array;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof BugPattern) {
                BugPattern pattern = (BugPattern)element;
                return DetectorFactoryCollection.instance().getBugCode(pattern.getAbbrev());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof BugCode;
        }

        public void inputChanged(Viewer viewer1, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private final class TreeCheckStateListener
    implements ICheckStateListener {
        private TreeCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            FilterBugsDialog.this.elementChecked(element, checked);
            FilterBugsDialog.this.updateTextIds();
        }
    }

    private final class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            FilterBugsDialog.this.updateDescription(selection);
        }
    }
}

