/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugByIdFilter;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.DeltaInfo;
import de.tobject.findbugs.view.explorer.GroupType;
import de.tobject.findbugs.view.explorer.Grouping;
import de.tobject.findbugs.view.explorer.MarkerMapper;
import de.tobject.findbugs.view.explorer.RefreshJob;
import de.tobject.findbugs.view.explorer.WorkingSetsFilter;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class BugContentProvider
implements ICommonContentProvider {
    public static boolean DEBUG;
    private static final IMarker[] EMPTY;
    private final RefreshJob refreshJob;
    private Grouping grouping;
    private Object input;
    private BugGroup rootElement;
    private final WorkingSetsFilter resourceFilter;
    private CommonViewer viewer;
    private ICommonContentExtensionSite site;
    private final Map<BugGroup, Integer> filteredMarkersMap = new HashMap<BugGroup, Integer>();
    private final HashSet<IMarker> filteredMarkers = new HashSet();
    private boolean bugFilterActive;

    public BugContentProvider() {
        this.resourceFilter = new WorkingSetsFilter();
        this.rootElement = new BugGroup(null, null, GroupType.Undefined);
        this.refreshJob = new RefreshJob("Updating bugs in bug explorer", this);
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        String saved = store.getString("lastUsedGrouping");
        this.setGrouping(Grouping.restoreFrom(saved));
        saved = store.getString("lastUsedWorkingSet");
        this.initWorkingSet(saved);
        FindbugsPlugin.applyCustomDetectors(false);
    }

    public Object[] getChildren(Object parent) {
        if (this.grouping == null) {
            return EMPTY;
        }
        Object[] children = EMPTY;
        if (parent instanceof BugGroup) {
            BugGroup group = (BugGroup)parent;
            children = group.getChildren();
            if (this.rootElement == parent && this.rootElement.size() == 0 && DEBUG) {
                System.out.println("Root is empty...");
            }
        } else if (parent instanceof IWorkspaceRoot || parent instanceof IWorkingSet) {
            Object[] objects;
            if (this.input == parent && (objects = this.rootElement.getChildren()).length > 0) {
                if (this.bugFilterActive != this.isBugFilterActive()) {
                    this.refreshFilters();
                }
                return objects;
            }
            BugGroup root = new BugGroup(null, parent, GroupType.getType(parent));
            this.clearFilters();
            children = this.createChildren(this.grouping.getFirstType(), this.getResources(parent), root);
            if (this.input == parent) {
                this.rootElement = root;
            }
        }
        return children;
    }

    private Set<IResource> getResources(Object parent) {
        HashSet<IResource> resources;
        block3: {
            IProject[] projects;
            block2: {
                IAdaptable[] elements;
                resources = new HashSet<IResource>();
                if (!(parent instanceof IWorkingSet)) break block2;
                IWorkingSet workingSet = (IWorkingSet)parent;
                for (IAdaptable adaptable : elements = workingSet.getElements()) {
                    IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                    if (resource == null) continue;
                    resources.add(resource);
                }
                break block3;
            }
            if (!(parent instanceof IWorkspaceRoot)) break block3;
            IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)parent;
            for (IProject project : projects = workspaceRoot.getProjects()) {
                resources.add((IResource)project);
            }
        }
        return resources;
    }

    public Object getParent(Object element) {
        if (element instanceof BugGroup) {
            BugGroup groupElement = (BugGroup)element;
            return groupElement.getParent();
        }
        if (element instanceof IMarker) {
            return this.findParent((IMarker)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof BugGroup || element instanceof IWorkingSet || element instanceof IWorkspaceRoot;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (DEBUG) {
            System.out.println("Disposing content provider!");
        }
        this.refreshJob.dispose();
        this.rootElement.dispose();
        this.clearFilters();
        IPreferenceStore store = FindbugsPlugin.getDefault().getPreferenceStore();
        store.setValue("lastUsedGrouping", this.getGrouping().toString());
        IWorkingSet workingSet = this.getCurrentWorkingSet();
        String name = workingSet != null ? workingSet.getName() : "";
        store.setValue("lastUsedWorkingSet", name);
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        this.viewer = (CommonViewer)newViewer;
        if (newInput == null || newInput instanceof IWorkingSet || newInput instanceof IWorkspaceRoot) {
            this.rootElement.dispose();
        }
        this.input = newInput;
        if (newInput == null) {
            this.refreshJob.setViewer(null);
        } else {
            this.refreshJob.setViewer((CommonViewer)newViewer);
            this.bugFilterActive = this.isBugFilterActive();
        }
        this.clearFilters();
    }

    public void reSetInput() {
        this.clearFilters();
        Object oldInput = this.getInput();
        this.viewer.setInput(null);
        this.rootElement.dispose();
        this.rootElement = new BugGroup(null, null, GroupType.Undefined);
        if (oldInput instanceof IWorkingSet || oldInput instanceof IWorkspaceRoot) {
            this.viewer.setInput(oldInput);
        } else {
            IWorkingSet workingSet = this.getCurrentWorkingSet();
            if (workingSet != null) {
                this.viewer.setInput((Object)workingSet);
            } else {
                this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            }
        }
    }

    public void clearFilters() {
        if (DEBUG) {
            System.out.println("Clear filters!");
        }
        this.filteredMarkers.clear();
        this.filteredMarkersMap.clear();
    }

    public void refreshFilters() {
        this.clearFilters();
        this.bugFilterActive = this.isBugFilterActive();
        if (!this.bugFilterActive) {
            return;
        }
        if (DEBUG) {
            System.out.println("Refreshing filters!");
        }
        Set<String> patternFilter = this.getPatternFilter();
        for (IMarker marker : this.rootElement.getAllMarkers()) {
            if (!MarkerUtil.isFiltered(marker, patternFilter)) continue;
            this.filteredMarkers.add(marker);
        }
    }

    public synchronized int getFilteredMarkersCount(BugGroup bugGroup) {
        if (!this.isBugFilterActive()) {
            return 0;
        }
        Integer bugCount = this.filteredMarkersMap.get(bugGroup);
        if (bugCount == null) {
            int count = 0;
            for (IMarker marker : bugGroup.getAllMarkers()) {
                if (!this.isFiltered(marker)) continue;
                ++count;
            }
            bugCount = count;
            this.filteredMarkersMap.put(bugGroup, bugCount);
        }
        return bugCount;
    }

    private Set<String> getPatternFilter() {
        return FindbugsPlugin.getFilteredIds();
    }

    public boolean isFiltered(IMarker marker) {
        return this.filteredMarkers.contains(marker);
    }

    public Object getInput() {
        return this.input;
    }

    IWorkingSet getCurrentWorkingSet() {
        return this.resourceFilter.getWorkingSet();
    }

    void setCurrentWorkingSet(IWorkingSet workingSet) {
        this.resourceFilter.setWorkingSet(workingSet);
    }

    private synchronized Object[] createChildren(GroupType desiredType, Set<IResource> parents, BugGroup parent) {
        HashSet<IMarker> markerSet = new HashSet<IMarker>();
        boolean filterActive = this.isBugFilterActive();
        Set<String> patternFilter = this.getPatternFilter();
        for (IResource resource : parents) {
            IMarker[] markers;
            for (IMarker marker : markers = this.getMarkers(resource)) {
                boolean added = markerSet.add(marker);
                if (!filterActive || !added || !MarkerUtil.isFiltered(marker, patternFilter)) continue;
                this.filteredMarkers.add(marker);
            }
        }
        parent.setMarkers(markerSet);
        return this.createGroups(parent, desiredType.getMapper());
    }

    private synchronized <Identifier> Object[] createGroups(BugGroup parent, MarkerMapper<Identifier> mapper) {
        if (mapper == MarkerMapper.NO_MAPPING) {
            return parent.getAllMarkers().toArray(new IMarker[0]);
        }
        Set<IMarker> allMarkers = parent.getAllMarkers();
        GroupType childType = this.grouping.getChildType(mapper.getType());
        HashMap groupIds = new HashMap();
        UserPreferences prefs = FindbugsPlugin.getCorePreferences(null, false);
        Set<String> disabledPlugins = prefs.getCustomPlugins(false);
        HashSet<String> errorMessages = new HashSet<String>();
        for (IMarker marker : allMarkers) {
            Identifier id = mapper.getIdentifier(marker);
            if (id == null) {
                String pluginId = MarkerUtil.getPluginId(marker);
                if (pluginId.length() == 0 || disabledPlugins.contains(pluginId)) continue;
                try {
                    String debugDescription = mapper.getDebugDescription(marker);
                    if (errorMessages.contains(debugDescription)) continue;
                    errorMessages.add(debugDescription);
                    if (!FindbugsPlugin.getDefault().isDebugging()) continue;
                    FindbugsPlugin.getDefault().logWarning("BugContentProvider.createGroups: failed to find " + debugDescription + " for marker on file " + marker.getResource());
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Exception on retrieving debug data for: " + (Object)((Object)mapper.getType()));
                }
                continue;
            }
            if (!groupIds.containsKey(id)) {
                groupIds.put(id, new HashSet());
            }
            ((Set)groupIds.get(id)).add(marker);
        }
        Set typesSet = groupIds.entrySet();
        Object[] children = new BugGroup[typesSet.size()];
        boolean lastlevel = this.grouping.getChildType(mapper.getType()) == GroupType.Marker;
        int i = 0;
        for (Map.Entry entry : typesSet) {
            Object groupId = entry.getKey();
            children[i] = new BugGroup(parent, groupId, mapper.getType());
            ((BugGroup)children[i]).setMarkers((Set)entry.getValue());
            ++i;
        }
        if (!lastlevel) {
            for (Object bugGroup : children) {
                this.createGroups((BugGroup)bugGroup, childType.getMapper());
            }
        }
        return children;
    }

    private IMarker[] getMarkers(IResource resource) {
        if (resource instanceof IProject && !((IProject)resource).isAccessible()) {
            return EMPTY;
        }
        if (!this.resourceFilter.contains(resource)) {
            return EMPTY;
        }
        return MarkerUtil.getAllMarkers(resource);
    }

    public void setGrouping(Grouping grouping) {
        this.grouping = grouping;
        if (this.viewer != null) {
            this.refreshJob.setViewer(this.viewer);
        }
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public void saveState(IMemento memento) {
        if (DEBUG) {
            System.out.println("Save state!");
        }
    }

    public void init(ICommonContentExtensionSite config) {
        this.site = config;
    }

    public void restoreState(IMemento memento) {
        if (DEBUG) {
            System.out.println("Restore state!");
        }
    }

    protected void initWorkingSet(String workingSetName) {
        IWorkingSet workingSet = null;
        if (workingSetName != null && workingSetName.length() > 0) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            workingSet = workingSetManager.getWorkingSet(workingSetName);
        }
        if (workingSet != null) {
            this.setCurrentWorkingSet(workingSet);
        }
    }

    public synchronized Set<BugGroup> updateContent(List<DeltaInfo> deltas) {
        int oldRootSize = this.rootElement.getChildren().length;
        HashSet<BugGroup> changedParents = new HashSet<BugGroup>();
        this.bugFilterActive = this.isBugFilterActive();
        Set<String> patternFilter = this.getPatternFilter();
        block4: for (DeltaInfo delta : deltas) {
            if (DEBUG) {
                System.out.println(delta + " (contentProvider.updateContent)");
            }
            IMarker changedMarker = delta.marker;
            switch (delta.changeKind) {
                case 2: {
                    BugGroup parent = this.findParent(changedMarker);
                    if (parent == null) {
                        if (!DEBUG) continue block4;
                        System.out.println(delta + " IGNORED because marker does not have parent!");
                        continue block4;
                    }
                    this.removeMarker(parent, changedMarker, changedParents);
                    continue block4;
                }
                case 1: {
                    if (!changedMarker.exists()) {
                        if (!DEBUG) continue block4;
                        System.out.println(delta + " IGNORED because marker does not exists anymore!");
                        continue block4;
                    }
                    this.addMarker(changedMarker, changedParents, patternFilter);
                    continue block4;
                }
            }
            FindbugsPlugin.getDefault().logWarning("UKNOWN delta change kind" + delta.changeKind);
        }
        if (this.rootElement.getMarkersCount() == 0 || this.rootElement.getChildren().length != oldRootSize) {
            if (oldRootSize == 0 || this.rootElement.getChildren().length == 0) {
                changedParents.clear();
            } else {
                changedParents.add(this.rootElement);
            }
            return changedParents;
        }
        changedParents.add(this.rootElement);
        return changedParents;
    }

    private void removeMarker(BugGroup parent, IMarker marker, Set<BugGroup> changedParents) {
        BugGroup accessibleParent = this.getFirstAccessibleParent(parent);
        changedParents.add(accessibleParent);
        this.removeMarker(parent, marker);
    }

    private void addMarker(IMarker toAdd, Set<BugGroup> changedParents, Set<String> patternFilter) {
        MarkerMapper<?> mapper = this.grouping.getFirstType().getMapper();
        IMarker marker = toAdd;
        if (!this.resourceFilter.contains(marker.getResource())) {
            return;
        }
        this.rootElement.addMarker(marker);
        this.addMarker(marker, mapper, this.rootElement, changedParents, patternFilter);
    }

    private <Identifier> void addMarker(IMarker marker, MarkerMapper<Identifier> mapper, BugGroup parent, Set<BugGroup> changedParents, Set<String> patternFilter) {
        boolean filtered;
        if (mapper == MarkerMapper.NO_MAPPING) {
            return;
        }
        Identifier id = mapper.getIdentifier(marker);
        if (id == null) {
            if (FindbugsPlugin.getDefault().isDebugging()) {
                FindbugsPlugin.getDefault().logWarning("BugContentProvider.createPatternGroups: Failed to find bug id of type " + (Object)((Object)mapper.getType()) + " for marker on file " + marker.getResource());
            }
            return;
        }
        BugGroup matchingChild = null;
        for (Object object : parent.getChildren()) {
            if (!(object instanceof BugGroup)) break;
            BugGroup group = (BugGroup)object;
            if (!id.equals(group.getData())) continue;
            matchingChild = group;
            break;
        }
        GroupType childType = this.grouping.getChildType(mapper.getType());
        boolean bl = filtered = this.bugFilterActive && MarkerUtil.isFiltered(marker, patternFilter);
        if (filtered) {
            this.filteredMarkers.add(marker);
        }
        if (matchingChild != null) {
            boolean lastlevel;
            matchingChild.addMarker(marker);
            if (filtered) {
                Integer count = this.filteredMarkersMap.get(matchingChild);
                if (count == null) {
                    count = 0;
                }
                this.filteredMarkersMap.put(matchingChild, count + 1);
            }
            if (this.isAccessible(matchingChild)) {
                changedParents.add(this.getFirstAccessibleParent(matchingChild));
            }
            boolean bl2 = lastlevel = childType == GroupType.Marker;
            if (!lastlevel) {
                this.addMarker(marker, childType.getMapper(), matchingChild, changedParents, patternFilter);
            }
        } else {
            BugGroup group = new BugGroup(parent, id, mapper.getType());
            group.addMarker(marker);
            if (filtered) {
                this.filteredMarkersMap.put(group, 1);
            }
            this.createGroups(group, childType.getMapper());
        }
    }

    public boolean isAccessible(BugGroup group) {
        BugGroup rootGroup = !(this.input instanceof BugGroup) ? this.rootElement : (BugGroup)this.input;
        return this.grouping.compare(rootGroup.getType(), group.getType()) < 0;
    }

    private void removeMarker(BugGroup parent, IMarker marker) {
        parent.removeMarker(marker);
        List<BugGroup> parents = this.getSelfAndParents(parent);
        boolean filtered = this.isFiltered(marker);
        for (BugGroup group : parents) {
            Integer count;
            if (group.getMarkersCount() == 0 && group.getParent() instanceof BugGroup) {
                this.removeGroup((BugGroup)group.getParent(), group);
            }
            if (!filtered || (count = this.filteredMarkersMap.get(group)) == null || count <= 0) continue;
            this.filteredMarkersMap.put(group, count - 1);
        }
        this.filteredMarkers.remove(marker);
    }

    private void removeGroup(BugGroup parent, BugGroup child) {
        if (parent.removeChild(child)) {
            this.filteredMarkersMap.remove(child);
            if (parent.getMarkersCount() == 0 && parent.getParent() instanceof BugGroup) {
                this.removeGroup((BugGroup)parent.getParent(), parent);
            }
        }
    }

    private List<BugGroup> getSelfAndParents(BugGroup child) {
        ArrayList<BugGroup> parents = new ArrayList<BugGroup>();
        parents.add(child);
        while (child.getParent() instanceof BugGroup) {
            child = (BugGroup)child.getParent();
            parents.add(child);
        }
        return parents;
    }

    private BugGroup getFirstAccessibleParent(BugGroup element) {
        if (element.getParent() instanceof BugGroup) {
            BugGroup parent = (BugGroup)element.getParent();
            if (!this.isAccessible(parent)) {
                return element;
            }
            return this.getFirstAccessibleParent(parent);
        }
        return element;
    }

    private BugGroup findParent(IMarker marker) {
        Object object;
        Object[] rootObjects = this.rootElement.getChildren();
        GroupType parentType = this.grouping.getParentType(GroupType.Marker);
        if (parentType == GroupType.Undefined) {
            return null;
        }
        for (int i = 0; i < rootObjects.length && (object = rootObjects[i]) instanceof BugGroup; ++i) {
            BugGroup group = (BugGroup)object;
            if (!group.contains(marker)) continue;
            if (group.getType() == parentType) {
                return group;
            }
            rootObjects = group.getChildren();
            i = -1;
        }
        return null;
    }

    public static BugContentProvider getProvider(INavigatorContentService service) {
        INavigatorContentExtension extensionById = service.getContentExtensionById("de.tobject.findbugs.view.explorer.BugContentProvider");
        ITreeContentProvider provider = extensionById.getContentProvider();
        if (provider instanceof BugContentProvider) {
            return (BugContentProvider)provider;
        }
        return null;
    }

    public boolean isBugFilterActive() {
        return BugContentProvider.isBugFilterActive(this.site);
    }

    public static boolean isBugFilterActive(ICommonContentExtensionSite site) {
        ViewerFilter[] visibleFilters;
        for (ViewerFilter filter : visibleFilters = site.getService().getFilterService().getVisibleFilters(true)) {
            if (!(filter instanceof BugByIdFilter)) continue;
            return true;
        }
        return false;
    }

    public Set<Object> getShowInTargets(Object obj) {
        HashSet<Object> supported = new HashSet<Object>();
        if (obj instanceof BugGroup) {
            supported.add(obj);
        } else if (obj instanceof IMarker) {
            supported.add(obj);
        } else {
            if (obj instanceof IJavaProject) {
                return this.getShowInTargets(((IJavaProject)obj).getProject());
            }
            if (obj instanceof IClassFile) {
                return this.getShowInTargets(((IClassFile)obj).getType());
            }
            if (obj instanceof IFile) {
                IJavaElement javaElement = JavaCore.create((IFile)((IFile)obj));
                return this.getShowInTargets(javaElement);
            }
            if (obj instanceof IFolder) {
                IJavaElement javaElement = JavaCore.create((IFolder)((IFolder)obj));
                return this.getShowInTargets(javaElement);
            }
            if (obj instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)obj;
                for (Object object : selection) {
                    supported.add(this.getShowInTargets(object));
                }
            } else {
                Set<IMarker> markers = MarkerUtil.getMarkers(obj);
                boolean found = false;
                block1: for (IMarker marker : markers) {
                    BugGroup group = this.findParent(marker);
                    if (group == null) continue;
                    List<BugGroup> selfAndParents = this.getSelfAndParents(group);
                    for (BugGroup bugGroup : selfAndParents) {
                        if (!obj.equals(bugGroup.getData())) continue;
                        supported.add(bugGroup);
                        found = true;
                        break block1;
                    }
                }
                if (!found) {
                    supported.addAll(markers);
                }
            }
        }
        return supported;
    }

    static {
        EMPTY = new IMarker[0];
    }
}

