/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.IMarkerSelectionHandler;
import de.tobject.findbugs.view.MarkerSelectionListener;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class BugExplorerView
extends CommonNavigator
implements IMarkerSelectionHandler,
ISelectionChangedListener {
    private MarkerSelectionListener selectionListener;
    private static final String TAG_MEMENTO = "memento";
    private IMemento viewMemento;
    protected boolean selectionInProgress;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new MarkerSelectionListener(this){

            @Override
            public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
                BugExplorerView.this.selectionInProgress = true;
                super.selectionChanged(thePart, theSelection);
                BugExplorerView.this.selectionInProgress = false;
            }
        };
        theService.addSelectionListener((ISelectionListener)this.selectionListener);
        this.getCommonViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    public boolean isVisible() {
        return this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    @Override
    public void markerSelected(IWorkbenchPart part, IMarker marker) {
        if (this.selectionInProgress) {
            return;
        }
        BugContentProvider provider = BugContentProvider.getProvider(this.getNavigatorContentService());
        CommonViewer commonViewer = this.getCommonViewer();
        if (marker == null) {
            commonViewer.setSelection((ISelection)new StructuredSelection(), false);
        } else if (provider.isFiltered(marker)) {
            Object parent = provider.getParent(marker);
            if (parent != null) {
                commonViewer.setSelection((ISelection)new StructuredSelection(parent), true);
            }
        } else {
            commonViewer.setSelection((ISelection)new StructuredSelection((Object)marker), true);
        }
    }

    public void updateTitle() {
        super.updateTitle();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.viewMemento = memento;
        if (memento == null) {
            IDialogSettings dialogSettings = FindbugsPlugin.getDefault().getDialogSettings();
            String persistedMemento = dialogSettings.get(TAG_MEMENTO);
            if (persistedMemento == null) {
                memento = XMLMemento.createWriteRoot((String)"bugExplorer");
            } else {
                try {
                    memento = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
                }
                catch (WorkbenchException e) {
                    // empty catch block
                }
            }
        }
        super.init(site, memento);
    }

    public Object getAdapter(Class clazz) {
        Object adapter = super.getAdapter(clazz);
        if (adapter == null && clazz == IMemento.class) {
            return this.viewMemento;
        }
        return adapter;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void dispose() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"bugExplorer");
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            IDialogSettings dialogSettings = FindbugsPlugin.getDefault().getDialogSettings();
            dialogSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.selectionListener);
            this.selectionListener = null;
        }
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty() || selection.size() == 1) {
            this.setContentDescription("");
        } else {
            this.setContentDescription(this.getFrameToolTipText(selection));
        }
    }

    public void selectReveal(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            super.selectReveal(selection);
            return;
        }
        selection = this.adaptSelection((IStructuredSelection)selection);
        super.selectReveal(selection);
    }

    private ISelection adaptSelection(IStructuredSelection selection) {
        BugContentProvider provider = BugContentProvider.getProvider(this.getNavigatorContentService());
        HashSet<Object> accepted = new HashSet<Object>();
        for (Object object : selection) {
            Set<Object> supported = provider.getShowInTargets(object);
            accepted.addAll(supported);
        }
        return new StructuredSelection(accepted.toArray());
    }
}

