/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.properties.IPathElement;
import edu.umd.cs.findbugs.Plugin;
import org.eclipse.core.runtime.IStatus;

public class PluginElement
implements IPathElement {
    private final Plugin plugin;
    private boolean enabled;
    private final boolean eclipsePlugin;
    private IStatus status;

    public PluginElement(Plugin plugin, boolean eclipsePlugin) {
        this.plugin = plugin;
        this.eclipsePlugin = eclipsePlugin;
        this.enabled = plugin.isGloballyEnabled();
    }

    public String toString() {
        String string = "";
        if (this.eclipsePlugin) {
            string = "(Eclipse) ";
        }
        string = string + this.plugin.getShortDescription() + " [" + this.plugin.getPluginId() + "]" + (this.isEnabled() ? "" : " (disabled)");
        return string;
    }

    @Override
    public String getPath() {
        return this.plugin.getPluginId();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PluginElement) {
            return this.plugin.equals(((PluginElement)obj).plugin) && this.enabled == ((PluginElement)obj).enabled;
        }
        return false;
    }

    public int hashCode() {
        return this.plugin.hashCode();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.plugin.isCorePlugin() || !enabled && this.plugin.cannotDisable()) {
            return;
        }
        this.plugin.setGloballyEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public void setStatus(IStatus status) {
        this.status = status;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public String getId() {
        return this.plugin.getPluginId();
    }
}

