/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.view.BugExplorerView;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.Grouping;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonViewer;

public class GoUpAction
implements IViewActionDelegate {
    private BugExplorerView navigator;

    public void init(IViewPart view) {
        if (view instanceof BugExplorerView) {
            this.navigator = (BugExplorerView)view;
        }
    }

    public void run(IAction action) {
        if (!action.isEnabled()) {
            return;
        }
        CommonViewer viewer = this.navigator.getCommonViewer();
        Object[] expandedElements = viewer.getVisibleExpandedElements();
        Object input = viewer.getInput();
        if (input instanceof BugGroup) {
            boolean needRefresh;
            BugGroup group = (BugGroup)input;
            Object data = group.getParent();
            boolean bl = needRefresh = data == null;
            if (needRefresh) {
                BugContentProvider.getProvider(this.navigator.getNavigatorContentService()).reSetInput();
            } else {
                viewer.setInput(data);
            }
            viewer.setExpandedElements(expandedElements);
        }
        action.setEnabled(this.isEnabled());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        if (this.navigator == null) {
            return false;
        }
        Object input = this.navigator.getCommonViewer().getInput();
        if (input instanceof IMarker) {
            return true;
        }
        if (input instanceof BugGroup) {
            BugContentProvider provider = BugContentProvider.getProvider(this.navigator.getNavigatorContentService());
            BugGroup bugGroup = (BugGroup)input;
            Grouping grouping = provider.getGrouping();
            if (grouping == null) {
                return false;
            }
            return grouping.contains(bugGroup.getType());
        }
        return false;
    }
}

