/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.Util;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CopyMarkerDetailsAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection newSelection) {
        this.selection = newSelection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection.isEmpty() || !(this.selection instanceof IStructuredSelection)) {
            return;
        }
        Set<IMarker> markers = this.getMarkers();
        String content = this.getContent(markers);
        Util.copyToClipboard(content);
    }

    private String getContent(Set<IMarker> markers) {
        StringBuilder fullText = new StringBuilder();
        for (IMarker marker : markers) {
            try {
                StringBuilder line = new StringBuilder();
                IResource resource = marker.getResource();
                if (resource != null) {
                    IPath location = resource.getLocation();
                    if (location != null) {
                        line.append(location.toPortableString());
                    } else {
                        line.append(resource.getFullPath());
                    }
                }
                Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
                line.append(":").append(lineNumber);
                String message = (String)marker.getAttribute("message");
                line.append(" ").append(message);
                line.append(System.getProperty("line.separator", "\n"));
                fullText.append(line.toString());
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Exception while parsing content of FindBugs markers.");
            }
        }
        return fullText.toString();
    }

    private Set<IMarker> getMarkers() {
        return MarkerUtil.getMarkerFromSelection(this.selection);
    }
}

