/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.IGuiCallback;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.cloud.Cloud;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class EclipseGuiCallback
implements IGuiCallback {
    private final AbstractExecutorService guiExecutor = new EclipseDisplayThreadExecutor();
    private Cloud.CloudListener cloudListener;
    private final IProject iproject;

    public EclipseGuiCallback(IProject iproject) {
        this.iproject = iproject;
    }

    @Override
    public void registerCloud(Project project, BugCollection collection, final Cloud cloud) {
        this.cloudListener = new Cloud.CloudListener(){

            @Override
            public void statusUpdated() {
                final String statusMsg = cloud.getStatusMsg();
                final IWorkbenchWindow win = FindbugsPlugin.getActiveWorkbenchWindow();
                win.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = win.getActivePage();
                        IWorkbenchPart part = page.getActivePart();
                        if (part instanceof IEditorPart) {
                            IEditorPart epart = (IEditorPart)part;
                            Image image = FindbugsPlugin.getDefault().getImageRegistry().get("buggy-tiny-gray.png");
                            IStatusLineManager statusLineManager = epart.getEditorSite().getActionBars().getStatusLineManager();
                            if (statusMsg.equals("")) {
                                statusLineManager.setMessage("");
                            } else {
                                statusLineManager.setMessage(image, statusMsg);
                            }
                        }
                    }
                });
            }

            @Override
            public void issueUpdated(BugInstance bug) {
            }

            @Override
            public void taskStarted(final Cloud.CloudTask task) {
                task.setUseDefaultListener(false);
                Job job = new Job(task.getName()){

                    public boolean belongsTo(Object family) {
                        return FindbugsPlugin.class == family;
                    }

                    protected IStatus run(final IProgressMonitor monitor) {
                        monitor.beginTask(task.getName(), 1000);
                        monitor.subTask(task.getStatusLine());
                        monitor.worked((int)(task.getPercentCompleted() * 10.0));
                        final CountDownLatch latch = new CountDownLatch(1);
                        final AtomicBoolean success = new AtomicBoolean(false);
                        task.addListener(new Cloud.CloudTaskListener(){

                            @Override
                            public void taskStatusUpdated(String statusLine, double percentCompleted) {
                                monitor.subTask(statusLine);
                                monitor.worked((int)(percentCompleted * 10.0));
                            }

                            @Override
                            public void taskFinished() {
                                latch.countDown();
                                success.set(true);
                            }

                            @Override
                            public void taskFailed(String message) {
                                latch.countDown();
                                success.set(false);
                            }
                        });
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        monitor.subTask("");
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.schedule();
            }
        };
        cloud.addListener(this.cloudListener);
    }

    @Override
    public void unregisterCloud(Project project, BugCollection collection, Cloud cloud) {
        cloud.removeListener(this.cloudListener);
    }

    public String getProjectName() {
        try {
            return this.iproject.getDescription().getName();
        }
        catch (CoreException e) {
            return this.iproject.getName();
        }
    }

    public String getDialogTitle() {
        return this.getProjectName() + ": FindBugs";
    }

    public String getDialogTitle(String title) {
        return this.getProjectName() + ": " + title;
    }

    @Override
    public String showQuestionDialog(String message, String title, final String defaultValue) {
        final AtomicReference textBoxRef = new AtomicReference();
        MessageDialog dlg = new MessageDialog(FindbugsPlugin.getShell(), this.getDialogTitle(title), null, message, 3, new String[]{"OK", "Cancel"}, 1){

            protected Control createCustomArea(Composite parent) {
                Text text = new Text(parent, 4);
                text.setText(defaultValue);
                textBoxRef.set(text);
                return text;
            }
        };
        dlg.open();
        return ((Text)textBoxRef.get()).getText();
    }

    @Override
    public void showMessageDialogAndWait(String message) throws InterruptedException {
        MessageDialog.openInformation((Shell)FindbugsPlugin.getShell(), (String)this.getDialogTitle(), (String)message);
    }

    @Override
    public void showMessageDialog(final String message) {
        FindbugsPlugin.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)FindbugsPlugin.getShell(), (String)EclipseGuiCallback.this.getDialogTitle(), (String)message);
            }
        });
    }

    @Override
    public List<String> showForm(String message, String title, List<IGuiCallback.FormItem> labels) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean showDocument(URL u) {
        return Program.launch((String)u.toExternalForm());
    }

    @Override
    public int showConfirmDialog(final String message, final String title, final String ok, final String cancel) {
        final AtomicInteger result = new AtomicInteger(-1);
        FindbugsPlugin.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(FindbugsPlugin.getShell(), EclipseGuiCallback.this.getDialogTitle(title), null, message, 0, new String[]{ok, cancel}, 0);
                result.set(dialog.open());
            }
        });
        return result.get();
    }

    @Override
    public void setErrorMessage(String errorMsg) {
        this.showMessageDialog(errorMsg);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public void invokeInGUIThread(Runnable r) {
        FindbugsPlugin.getShell().getDisplay().asyncExec(r);
    }

    @Override
    public InputStream getProgressMonitorInputStream(InputStream in, int length, String msg) {
        return in;
    }

    @Override
    public ExecutorService getBugUpdateExecutor() {
        return this.guiExecutor;
    }

    @Override
    public void displayNonmodelMessage(final String title, final String message) {
        this.invokeInGUIThread(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)FindbugsPlugin.getShell(), (String)EclipseGuiCallback.this.getDialogTitle(title), (String)message);
            }
        });
    }

    private static final class EclipseDisplayThreadExecutor
    extends AbstractExecutorService {
        private EclipseDisplayThreadExecutor() {
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public void execute(Runnable command) {
            Display.getDefault().asyncExec(command);
        }
    }
}

