/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FieldLayoutPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private List<FieldEditor> m_fields = new ArrayList<FieldEditor>();
    private FieldEditor m_invalidFieldEditor;

    protected FieldLayoutPreferencePage() {
    }

    protected FieldLayoutPreferencePage(String title) {
        super(title);
    }

    protected FieldLayoutPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected void addField(FieldEditor editor) {
        this.m_fields.add(editor);
    }

    protected void checkState() {
        boolean valid = true;
        this.m_invalidFieldEditor = null;
        if (this.m_fields != null) {
            int size = this.m_fields.size();
            int i = 0;
            while (i < size) {
                FieldEditor editor = this.m_fields.get(i);
                boolean bl = valid = valid && editor.isValid();
                if (!valid) {
                    this.m_invalidFieldEditor = editor;
                    break;
                }
                ++i;
            }
        }
        this.setValid(valid);
    }

    protected Control createContents(Composite parent) {
        Control contens = this.createPageContents(parent);
        this.initialize();
        this.checkState();
        return contens;
    }

    protected abstract Control createPageContents(Composite var1);

    public void dispose() {
        super.dispose();
        if (this.m_fields != null) {
            for (FieldEditor editor : this.m_fields) {
                editor.setPage(null);
                editor.setPropertyChangeListener(null);
                editor.setPreferenceStore(null);
            }
        }
    }

    protected void initialize() {
        if (this.m_fields != null) {
            for (FieldEditor editor : this.m_fields) {
                editor.setPage(null);
                editor.setPropertyChangeListener((IPropertyChangeListener)this);
                editor.setPreferenceStore(this.getPreferenceStore());
                editor.load();
            }
        }
    }

    protected void performDefaults() {
        if (this.m_fields != null) {
            for (FieldEditor editor : this.m_fields) {
                editor.loadDefault();
            }
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.m_fields != null) {
            for (FieldEditor editor : this.m_fields) {
                editor.store();
            }
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.m_invalidFieldEditor = (FieldEditor)event.getSource();
                this.setValid(newValue);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.m_invalidFieldEditor != null) {
            this.m_invalidFieldEditor.setFocus();
        }
    }
}

