/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.preferences;

import com.chookapp.org.bracketeer.preferences.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class StringPartCheckBoxes
extends FieldEditor {
    private Composite _parent;
    private String _bracketsString;
    private List<Button> _pairsList;

    public StringPartCheckBoxes(String name, Composite parent, String bracketsString) {
        this.setPreferenceName(name);
        if (bracketsString == null) {
            bracketsString = "";
        }
        this._bracketsString = bracketsString;
        this._parent = parent;
        this._pairsList = new ArrayList<Button>();
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this._parent.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this._parent = parent;
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = numColumns;
        parent.setLayoutData((Object)griddata);
        Assert.isTrue((this._bracketsString.length() % 2 == 0 ? 1 : 0) != 0, (String)Messages.StringPartCheckBoxes_ErrSupportedBrackets);
        int i = 0;
        while (i < this._bracketsString.length()) {
            String pair = this._bracketsString.substring(i, i + 2);
            Button btnCheckButton = new Button(parent, 32);
            btnCheckButton.setText(pair);
            this._pairsList.add(btnCheckButton);
            i += 2;
        }
    }

    protected void doLoad() {
        String str = this.getPreferenceStore().getString(this.getPreferenceName());
        this.updateButtons(str);
    }

    protected void doLoadDefault() {
        String str = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.updateButtons(str);
    }

    protected void doStore() {
        StringBuilder sb = new StringBuilder();
        for (Button btn : this._pairsList) {
            if (!btn.getSelection()) continue;
            sb.append(btn.getText());
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), sb.toString());
    }

    public int getNumberOfControls() {
        return 2;
    }

    private void updateButtons(String str) {
        for (Button btn : this._pairsList) {
            btn.setSelection(str.contains(btn.getText()));
        }
    }
}

