/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.preferences;

import com.chookapp.org.bracketeer.preferences.Messages;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ModifiersKeySequenceText
extends FieldEditor
implements KeyListener {
    Text _textField;
    int _mask;

    public ModifiersKeySequenceText(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public void keyPressed(KeyEvent e) {
        switch (e.keyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: {
                this._mask |= e.keyCode;
                this.generateTextFromMask();
                break;
            }
            case 8: 
            case 127: {
                this._mask = 0;
                this.generateTextFromMask();
            }
        }
    }

    private void generateTextFromMask() {
        if (this._textField == null) {
            return;
        }
        KeyStroke stroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)this._mask);
        String str = stroke.format();
        if (str.endsWith("+")) {
            str = str.substring(0, str.length() - 1);
        }
        this._textField.setText(str);
    }

    public void keyReleased(KeyEvent e) {
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this._textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this._textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this._textField.setLayoutData((Object)gd);
        this._textField.setToolTipText(Messages.ModifiersKeySequenceText_ModifiersToolTip);
    }

    protected void doLoad() {
        this._mask = this.getPreferenceStore().getInt(this.getPreferenceName());
        this.generateTextFromMask();
    }

    protected void doLoadDefault() {
        this._mask = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
        this.generateTextFromMask();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this._mask);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void dispose() {
        if (this._textField != null) {
            this._textField.removeKeyListener((KeyListener)this);
        }
        super.dispose();
    }

    public void setFocus() {
        if (this._textField != null) {
            this._textField.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }

    public Text getTextControl(Composite parent) {
        if (this._textField == null) {
            this._textField = new Text(parent, 2052);
            this._textField.setFont(parent.getFont());
            this._textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ModifiersKeySequenceText.this._textField = null;
                }
            });
            this._textField.addKeyListener((KeyListener)this);
        } else {
            this.checkParent((Control)this._textField, parent);
        }
        return this._textField;
    }
}

