/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.preferences;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.preferences.NonPersistantPreferencesStore;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.FieldLayoutPreferencePage;

public abstract class ChangingFieldsPrefPage
extends FieldLayoutPreferencePage {
    protected ArrayList<String> _prefNames = new ArrayList();
    private IPreferenceStore _tempPrefs = new NonPersistantPreferencesStore();
    private IPreferenceStore _realPrefs = Activator.getDefault().getPreferenceStore();

    protected ChangingFieldsPrefPage() {
        this.setPreferenceStore(this._tempPrefs);
    }

    @Override
    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this._prefNames.add(editor.getPreferenceName());
    }

    @Override
    protected void initialize() {
        for (String attr : this._prefNames) {
            this._tempPrefs.setDefault(attr, this._realPrefs.getDefaultString(attr));
            this._tempPrefs.setValue(attr, this._realPrefs.getString(attr));
        }
        super.initialize();
    }

    @Override
    public boolean performOk() {
        super.performOk();
        for (String attr : this._prefNames) {
            this._realPrefs.setValue(attr, this._tempPrefs.getString(attr));
        }
        if (this._realPrefs.needsSaving() && this._realPrefs instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this._realPrefs).save();
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return true;
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        for (String attr : this._prefNames) {
            this._tempPrefs.setValue(attr, this._realPrefs.getDefaultString(attr));
        }
        this.updateAll();
    }

    protected void setEnable(Composite comp, boolean enable) {
        Control[] controls = comp.getChildren();
        if (controls == null) {
            return;
        }
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite && !(c instanceof Spinner)) {
                this.setEnable((Composite)c, enable);
            } else {
                c.setEnabled(enable);
            }
            ++n2;
        }
    }

    protected abstract void updateAll();
}

