/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.core.BracketeerProcessorInfo;
import com.chookapp.org.bracketeer.core.Messages;
import com.chookapp.org.bracketeer.core.ProcessorConfiguration;
import com.chookapp.org.bracketeer.extensionpoint.BracketeerProcessor;
import com.chookapp.org.bracketeer.extensionpoint.IBracketeerProcessorsFactory;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;

public class ProcessorsRegistry {
    public static final String PROC_FACTORY_ID = "com.chookapp.org.bracketeer.processorsFactory";
    public static final String SUPPORTED_BRACKETS_ATTR = "supportedBrackets";
    private List<IBracketeerProcessorsFactory> _processorFactories = new LinkedList<IBracketeerProcessorsFactory>();
    private List<ProcessorConfiguration> _processorConfigurations = new LinkedList<ProcessorConfiguration>();

    public ProcessorsRegistry() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(PROC_FACTORY_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object o = element.createExecutableExtension("class");
                this._processorFactories.add((IBracketeerProcessorsFactory)o);
                this._processorConfigurations.add(new ProcessorConfiguration(element));
            }
            catch (Exception e) {
                Activator.log(e);
            }
            ++n2;
        }
    }

    public BracketeerProcessorInfo findProcessorFor(IEditorPart part, IDocument doc) {
        BracketeerProcessorInfo processorInfoFound = null;
        int i = 0;
        while (i < this._processorFactories.size()) {
            BracketeerProcessor processor = this._processorFactories.get(i).createProcessorFor(part, doc);
            if (processor != null) {
                if (processorInfoFound != null) {
                    throw new RuntimeException(Messages.ProcessorsRegistry_ErrProcExists);
                }
                processorInfoFound = new BracketeerProcessorInfo(processor, this._processorConfigurations.get(i));
            }
            ++i;
        }
        return processorInfoFound;
    }
}

