/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class PaintableObject {
    protected Position _position;
    protected RGB _foreground;
    protected RGB _background;

    public PaintableObject(Position position, RGB foreground, RGB background) {
        this._position = position;
        this._foreground = foreground;
        this._background = background;
    }

    public Position getPosition() {
        return this._position;
    }

    public RGB getForeground() {
        return this._foreground;
    }

    public RGB getBackground() {
        return this._background;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PaintableObject)) {
            return false;
        }
        PaintableObject other = (PaintableObject)obj;
        boolean eq = true;
        eq &= this._position.equals((Object)other._position);
        eq &= this.equalNulls(this._foreground, other._foreground);
        return eq &= this.equalNulls(this._background, other._background);
    }

    private boolean equalNulls(Object obj1, Object obj2) {
        if (obj1 == null ^ obj2 == null) {
            return false;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return true;
    }

    public void paint(GC gc, StyledText st, IDocument doc, IRegion widgetRange, Rectangle rect) {
        if (this._position.isDeleted || this._position.length == 0) {
            return;
        }
        if (widgetRange == null) {
            return;
        }
        Color bg = null;
        Color fg = null;
        Color oldBackground = null;
        Color oldForeground = null;
        if (this._background != null) {
            bg = new Color((Device)Display.getDefault(), this._background);
            oldBackground = gc.getBackground();
            gc.setBackground(bg);
        }
        if (this._foreground != null) {
            fg = new Color((Device)Display.getDefault(), this._foreground);
            oldForeground = gc.getForeground();
            gc.setForeground(fg);
        }
        this.innerPaint(gc, st, doc, widgetRange, rect);
        if (this._background != null) {
            gc.setBackground(oldBackground);
            bg.dispose();
        }
        if (this._foreground != null) {
            gc.setForeground(oldForeground);
            fg.dispose();
        }
    }

    protected abstract void innerPaint(GC var1, StyledText var2, IDocument var3, IRegion var4, Rectangle var5);
}

