/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.core.PaintableObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class PaintableHint
extends PaintableObject {
    private String _txt;
    private boolean _italic;
    private boolean _underline;

    public PaintableHint(Position drawPosition, RGB foreground, RGB background, boolean italic, String txt) {
        super(drawPosition, foreground, background);
        this._txt = txt;
        this._italic = italic;
        this._underline = false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PaintableHint)) {
            return false;
        }
        PaintableHint other = (PaintableHint)obj;
        if (!this._txt.equals(other._txt) || this._italic != other._italic) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected void innerPaint(GC gc, StyledText st, IDocument doc, IRegion widgetRange, Rectangle rect) {
        Font oldFont = null;
        Font newFont = null;
        if (this._italic) {
            oldFont = gc.getFont();
            FontData[] oldDatas = oldFont.getFontData();
            FontData[] newDatas = new FontData[oldDatas.length];
            int i = 0;
            while (i < oldDatas.length) {
                FontData oldData = oldDatas[i];
                FontData fontData = new FontData(oldData.getName(), oldData.getHeight(), 2);
                fontData.setLocale(oldData.getLocale());
                newDatas[i] = fontData;
                ++i;
            }
            newFont = new Font((Device)Display.getDefault(), newDatas);
            gc.setFont(newFont);
        }
        gc.drawText(this._txt, rect.x, rect.y, this._background == null);
        if (this._underline) {
            gc.drawLine(rect.x - 1, rect.y + rect.height - 1, rect.x + rect.width + 1, rect.y + rect.height - 1);
        }
        if (newFont != null) {
            gc.setFont(oldFont);
            newFont.dispose();
        }
    }

    public boolean isOkToShow(IDocument doc) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(this._position.getOffset());
        int startOffset = this._position.getOffset() + 1;
        int endOffset = region.getOffset() + region.getLength();
        if (startOffset >= (endOffset = Math.min(endOffset, doc.getLength() - 1))) {
            return true;
        }
        String str = doc.get(startOffset, endOffset - startOffset);
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '\t' && c != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Rectangle getWidgetRect(GC gc, StyledText st, IDocument doc, IRegion widgetRange) {
        block5: {
            block4: {
                try {
                    if (widgetRange != null) break block4;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            if (this.isOkToShow(doc)) break block5;
            return null;
        }
        int offset = widgetRange.getOffset();
        Point p = st.getLocationAtOffset(offset);
        p.x += gc.getAdvanceWidth(doc.getChar(this._position.getOffset()));
        Point metrics = gc.textExtent(this._txt);
        Rectangle rect = new Rectangle(p.x, p.y, metrics.x, metrics.y);
        return rect;
    }

    public void setUnderline(boolean underline) {
        this._underline = underline;
    }
}

