/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.core;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.common.BracketsPair;
import com.chookapp.org.bracketeer.common.Hint;
import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.SingleBracket;
import com.chookapp.org.bracketeer.core.IProcessingContainerListener;
import com.chookapp.org.bracketeer.core.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.services.IDisposable;

public class BracketeerProcessingContainer
implements IDisposable,
IBracketeerProcessingContainer {
    private IDocument _doc;
    private Object _docLock;
    private List<ObjectContainer<SingleBracket>> _singleBrackets = new ArrayList<ObjectContainer<SingleBracket>>();
    private List<ObjectContainer<BracketsPair>> _bracketsPairList = new LinkedList<ObjectContainer<BracketsPair>>();
    private List<ObjectContainer<Hint>> _hints = new LinkedList<ObjectContainer<Hint>>();
    private String _positionCategory;
    private IPositionUpdater _positionUpdater;
    private List<IProcessingContainerListener> _listeners;
    private boolean _bracketsPairsTouched;
    private boolean _singleBracketsTouched;
    private boolean _hintsTouched;
    private boolean _updatingListeners;

    public BracketeerProcessingContainer(IDocument doc) {
        this._doc = doc;
        this._docLock = this._doc instanceof ISynchronizable ? ((ISynchronizable)this._doc).getLockObject() : new Object();
        this._positionCategory = "bracketeerPosition";
        this._doc.addPositionCategory(this._positionCategory);
        this._positionUpdater = new DefaultPositionUpdater(this._positionCategory);
        this._doc.addPositionUpdater(this._positionUpdater);
        this._listeners = new LinkedList<IProcessingContainerListener>();
        this._updatingListeners = false;
    }

    public void dispose() {
        this._doc.removePositionUpdater(this._positionUpdater);
        try {
            this._doc.removePositionCategory(this._positionCategory);
        }
        catch (BadPositionCategoryException e) {
            Activator.log(e);
        }
    }

    public void addListener(IProcessingContainerListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IProcessingContainerListener listener) {
        if (!this._listeners.remove(listener)) {
            Activator.log(Messages.BracketeerProcessingContainer_listsnerNotFound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BracketsPair getMatchingPair(int openOffset, int closeOffset) {
        Object object = this._docLock;
        synchronized (object) {
            BracketsPair pair;
            Position openPos;
            ObjectContainer<BracketsPair> objCont;
            Iterator<ObjectContainer<BracketsPair>> iterator = this._bracketsPairList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while ((objCont = iterator.next()).isToDelete() || (openPos = (pair = objCont.getObject()).getOpeningBracket().getPosition()) == null || openPos.getOffset() != openOffset);
            Position closePos = pair.getClosingBracket().getPosition();
            if (closePos != null && closePos.getOffset() == closeOffset) {
                return pair;
            }
            Activator.log(String.format("[%1$d,%2$d] paritally found - %3$s", openOffset, closeOffset, pair.toString()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BracketsPair> getPairsSurrounding(int offset) {
        LinkedList<BracketsPair> retVal = new LinkedList<BracketsPair>();
        Object object = this._docLock;
        synchronized (object) {
            for (ObjectContainer<BracketsPair> objCont : this._bracketsPairList) {
                BracketsPair pair = objCont.getObject();
                Position opBrPos = pair.getOpeningBracket().getPosition();
                Position clBrPos = pair.getClosingBracket().getPosition();
                if (opBrPos == null || clBrPos == null || opBrPos.offset > offset || clBrPos.offset <= offset || retVal.contains(pair)) continue;
                retVal.add(pair);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BracketsPair> getMatchingPairs(int startOffset, int length) {
        LinkedList<BracketsPair> retVal = new LinkedList<BracketsPair>();
        Object object = this._docLock;
        synchronized (object) {
            block3: for (ObjectContainer<BracketsPair> objCont : this._bracketsPairList) {
                BracketsPair pair = objCont.getObject();
                for (SingleBracket br : pair.getBrackets()) {
                    Position pos = br.getPosition();
                    if (pos == null || !pos.overlapsWith(startOffset, length) || retVal.contains(pair)) continue;
                    retVal.add(pair);
                    continue block3;
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SingleBracket> getSingleBrackets() {
        LinkedList<SingleBracket> ret = new LinkedList<SingleBracket>();
        Object object = this._docLock;
        synchronized (object) {
            for (ObjectContainer<SingleBracket> objCont : this._singleBrackets) {
                SingleBracket br = objCont.getObject();
                if (br.getPosition() == null) continue;
                ret.add(br);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hint getHint(int startOffset) {
        Object object = this._docLock;
        synchronized (object) {
            for (ObjectContainer<Hint> objCont : this._hints) {
                Hint hint = objCont.getObject();
                Position pos = hint.getHintPosition();
                if (pos == null || !pos.overlapsWith(startOffset, 1)) continue;
                return hint;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Hint> getHints() {
        LinkedList<Hint> ret = new LinkedList<Hint>();
        Object object = this._docLock;
        synchronized (object) {
            for (ObjectContainer<Hint> objCont : this._hints) {
                Hint hint = objCont.getObject();
                if (hint.hasDeletedPosition()) continue;
                ret.add(hint);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BracketsPair> getBracketPairs() {
        LinkedList<BracketsPair> ret = new LinkedList<BracketsPair>();
        Object object = this._docLock;
        synchronized (object) {
            for (ObjectContainer<BracketsPair> objCont : this._bracketsPairList) {
                BracketsPair pair = objCont.getObject();
                if (pair.hasDeletedPosition()) continue;
                ret.add(pair);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllToBeDeleted() {
        Object object = this._docLock;
        synchronized (object) {
            for (ObjectContainer<BracketsPair> objectContainer : this._bracketsPairList) {
                objectContainer.setToDelete(true);
            }
            for (ObjectContainer<Object> objectContainer : this._singleBrackets) {
                objectContainer.setToDelete(true);
            }
            for (ObjectContainer<Object> objectContainer : this._hints) {
                objectContainer.setToDelete(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllMarked() {
        Object object = this._docLock;
        synchronized (object) {
            ObjectContainer<Object> objCont;
            Iterator<ObjectContainer<Object>> it = this._bracketsPairList.iterator();
            while (it.hasNext()) {
                objCont = it.next();
                if (!objCont.isToDelete()) continue;
                this._bracketsPairsTouched = true;
                for (SingleBracket bracket : objCont.getObject().getBrackets()) {
                    this.delete(bracket.getPositionRaw());
                }
                it.remove();
            }
            it = this._singleBrackets.iterator();
            while (it.hasNext()) {
                objCont = it.next();
                if (!objCont.isToDelete()) continue;
                this._singleBracketsTouched = true;
                this.delete(((SingleBracket)objCont.getObject()).getPositionRaw());
                it.remove();
            }
            it = this._hints.iterator();
            while (it.hasNext()) {
                objCont = it.next();
                if (!objCont.isToDelete()) continue;
                this._hintsTouched = true;
                this.delete(((Hint)objCont.getObject()).getOriginPositionRaw());
                this.delete(((Hint)objCont.getObject()).getHintPositionRaw());
                it.remove();
            }
        }
    }

    public void updateComplete() {
        this._updatingListeners = true;
        for (IProcessingContainerListener listener : this._listeners) {
            listener.containerUpdated(this._bracketsPairsTouched, this._singleBracketsTouched, this._hintsTouched);
        }
        this._bracketsPairsTouched = false;
        this._singleBracketsTouched = false;
        this._hintsTouched = false;
        this._updatingListeners = false;
    }

    public boolean isUpdatingListeners() {
        return this._updatingListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BracketsPair pair) throws BadLocationException {
        Object object = this._docLock;
        synchronized (object) {
            ObjectContainer<BracketsPair> existing = BracketeerProcessingContainer.findExistingObj(this._bracketsPairList, pair);
            if (existing != null) {
                if (existing.equals(pair) && !existing.getObject().hasDeletedPosition()) {
                    existing.setToDelete(false);
                    return;
                }
                this.deletePair(existing);
            }
            this._bracketsPairsTouched = true;
            ObjectContainer<BracketsPair> pairContainer = new ObjectContainer<BracketsPair>(pair);
            this._bracketsPairList.add(pairContainer);
            for (SingleBracket br : pair.getBrackets()) {
                this.addPosition(br.getPosition());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SingleBracket bracket) throws BadLocationException {
        Object object = this._docLock;
        synchronized (object) {
            ObjectContainer<SingleBracket> existing = BracketeerProcessingContainer.findExistingObj(this._singleBrackets, bracket);
            if (existing != null) {
                if (existing.equals(bracket) && existing.getObject().getPosition() != null) {
                    existing.setToDelete(false);
                    return;
                }
                this.deleteSingle(existing);
            }
            this._singleBracketsTouched = true;
            this._singleBrackets.add(new ObjectContainer<SingleBracket>(bracket));
            this.addPosition(bracket.getPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Hint hint) throws BadLocationException {
        Object object = this._docLock;
        synchronized (object) {
            ObjectContainer<Hint> existing = BracketeerProcessingContainer.findExistingObj(this._hints, hint);
            if (existing != null) {
                if (existing.equals(hint) && !existing.getObject().hasDeletedPosition()) {
                    existing.setToDelete(false);
                    return;
                }
                this.deleteHint(existing);
            }
            this._hintsTouched = true;
            this._hints.add(new ObjectContainer<Hint>(hint));
            this.addPosition(hint.getHintPositionRaw());
            this.addPosition(hint.getOriginPositionRaw());
        }
    }

    private void addPosition(Position position) throws BadLocationException {
        try {
            if (position != null) {
                this._doc.addPosition(this._positionCategory, position);
            }
        }
        catch (BadPositionCategoryException e) {
            Activator.log(e);
        }
    }

    private static <T> ObjectContainer<T> findExistingObj(List<ObjectContainer<T>> objList, T obj) {
        for (ObjectContainer<T> objCont : objList) {
            if (!objCont.equals(obj)) continue;
            return objCont;
        }
        return null;
    }

    private void delete(Position position) {
        try {
            this._doc.removePosition(this._positionCategory, position);
        }
        catch (BadPositionCategoryException e) {
            Activator.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePair(ObjectContainer<BracketsPair> objCont) {
        Object object = this._docLock;
        synchronized (object) {
            boolean found = this._bracketsPairList.remove(objCont);
            Assert.isTrue((boolean)found);
            for (SingleBracket bracket : objCont.getObject().getBrackets()) {
                this.delete(bracket.getPositionRaw());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSingle(ObjectContainer<SingleBracket> objCont) {
        Object object = this._docLock;
        synchronized (object) {
            boolean found = this._singleBrackets.remove(objCont);
            Assert.isTrue((boolean)found);
            SingleBracket bracket = objCont.getObject();
            this.delete(bracket.getPositionRaw());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHint(ObjectContainer<Hint> objCont) {
        Object object = this._docLock;
        synchronized (object) {
            boolean found = this._hints.remove(objCont);
            Assert.isTrue((boolean)found);
            Hint hint = objCont.getObject();
            this.delete(hint.getOriginPositionRaw());
            this.delete(hint.getHintPositionRaw());
        }
    }

    private class ObjectContainer<T> {
        private T _object;
        private boolean _toDelete;

        public ObjectContainer(T obj) {
            this._object = obj;
        }

        public T getObject() {
            return this._object;
        }

        public boolean isToDelete() {
            return this._toDelete;
        }

        public void setToDelete(boolean toDelete) {
            this._toDelete = toDelete;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof ObjectContainer) {
                return this._object.equals(((ObjectContainer)other)._object);
            }
            return this._object.equals(other);
        }
    }
}

