/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.commands;

import com.chookapp.org.bracketeer.Activator;
import com.chookapp.org.bracketeer.commands.Messages;
import com.chookapp.org.bracketeer.preferences.PreferencesConstants;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class BracketeerToggleState
extends State
implements IPropertyChangeListener,
IExecutableExtension,
ISourceProviderListener {
    private String _attrName = null;
    private String _attrSuffix;
    private IPreferenceStore _store = Activator.getDefault().getPreferenceStore();
    public static final String STATE_ID = "org.eclipse.ui.commands.toggleState";

    public BracketeerToggleState() {
        this._store.addPropertyChangeListener((IPropertyChangeListener)this);
        ISourceProviderService srcService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        ISourceProvider src = srcService.getSourceProvider("com.chookapp.org.bracketeer.pluginName");
        if (src == null) {
            Activator.log(Messages.BracketeerToggleState_SrcProviderNotFound);
        } else {
            src.addSourceProviderListener((ISourceProviderListener)this);
        }
        super.setValue((Object)false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this._attrName == null) {
            return;
        }
        if (!event.getProperty().equals(this._attrName)) {
            return;
        }
        this.setValue(this._store.getBoolean(this._attrName));
    }

    public void setValue(Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("ToggleState takes a Boolean as a value");
        }
        if (this._attrName == null) {
            throw new IllegalStateException(Messages.BracketeerToggleState_ErrAttrName);
        }
        this._store.setValue(this._attrName, ((Boolean)value).booleanValue());
        super.setValue(value);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data == null || !(data instanceof String)) {
            throw new IllegalArgumentException(Messages.BracketeerToggleState_ErrAttrSuffix);
        }
        this._attrSuffix = (String)data;
    }

    public void sourceChanged(int sourcePriority, Map sourceValuesByName) {
        Set set = sourceValuesByName.entrySet();
        for (Map.Entry entry : set) {
            this.sourceChanged(sourcePriority, (String)entry.getKey(), entry.getValue());
        }
    }

    public void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
        if (!sourceName.equals("com.chookapp.org.bracketeer.pluginName")) {
            return;
        }
        String processorName = (String)sourceValue;
        if (processorName == null || processorName.isEmpty()) {
            this._attrName = null;
        } else {
            this._attrName = String.valueOf(PreferencesConstants.preferencePath(processorName)) + this._attrSuffix;
            super.setValue((Object)this._store.getBoolean(this._attrName));
        }
    }
}

