/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.jdt;

import com.chookapp.org.bracketeer.common.BracketsPair;
import com.chookapp.org.bracketeer.common.Hint;
import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.IHintConfiguration;
import com.chookapp.org.bracketeer.common.MutableBool;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ClosingBracketHintVisitor
extends ASTVisitor {
    MutableBool _cancelProcessing;
    IBracketeerProcessingContainer _container;
    IHintConfiguration _hintConf;
    IDocument _doc;
    Stack<ScopeInfo> _scopeStack;

    public ClosingBracketHintVisitor(IBracketeerProcessingContainer container, IDocument doc, MutableBool cancelProcessing, IHintConfiguration hintConf) {
        this._cancelProcessing = cancelProcessing;
        this._container = container;
        this._doc = doc;
        this._hintConf = hintConf;
        this._scopeStack = new Stack();
    }

    private void removeFromStack(Statement node) {
        try {
            ScopeInfo scope;
            if (node instanceof SwitchStatement) {
                scope = this._scopeStack.peek();
                if (scope._statement instanceof SwitchCase) {
                    this._scopeStack.pop();
                }
            }
            scope = this._scopeStack.pop();
            if (!scope._statement.getClass().equals(node.getClass())) {
                // empty if block
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private void addBrackets(ParameterizedType node) throws BadLocationException {
        List args = node.typeArguments();
        if (args.isEmpty()) {
            return;
        }
        Type type = (Type)args.get(0);
        int startLoc = type.getStartPosition() - 1;
        type = (Type)args.get(args.size() - 1);
        int endLoc = type.getStartPosition() + type.getLength();
        this._container.add(new BracketsPair(startLoc, '<', endLoc, '>'));
    }

    private void addBrackets(List<TypeParameter> typeParameters) throws BadLocationException {
        if (typeParameters == null || typeParameters.isEmpty()) {
            return;
        }
        TypeParameter type = typeParameters.get(0);
        int startLoc = type.getStartPosition() - 1;
        type = typeParameters.get(typeParameters.size() - 1);
        int endLoc = type.getStartPosition() + type.getLength();
        this._container.add(new BracketsPair(startLoc, '<', endLoc, '>'));
    }

    public boolean visit(ParameterizedType node) {
        try {
            this.addBrackets(node);
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public boolean visit(SwitchCase node) {
        try {
            ScopeInfo scope = this._scopeStack.peek();
            if (!(scope._statement instanceof SwitchStatement)) {
                if (!(scope._statement instanceof SwitchCase)) {
                    throw new ScopeTraceException("Lost track of stack (in case), found:" + scope._statement);
                }
                this._scopeStack.pop();
                scope = this._scopeStack.peek();
            }
            if (!(scope._statement instanceof SwitchStatement)) {
                throw new ScopeTraceException("Lost track of stack (in case2), found:" + scope._statement);
            }
            String hint = "";
            hint = node.isDefault() ? "default" : "case: " + node.getExpression();
            int startLoc = node.getStartPosition();
            this._scopeStack.push(new ScopeInfo(String.valueOf(scope._str) + " - " + hint, startLoc, (Statement)node));
        }
        catch (ScopeTraceException scopeTraceException) {
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return this.shouldContinue();
    }

    public boolean visit(DoStatement node) {
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        int startLoc = node.getStartPosition();
        hint = "do_while( " + hint + " )";
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (Statement)node));
        return this.shouldContinue();
    }

    public void endVisit(DoStatement node) {
        this.removeFromStack((Statement)node);
        super.endVisit(node);
    }

    public boolean visit(BreakStatement node) {
        return this.visitBreak((Statement)node);
    }

    public boolean visit(ContinueStatement node) {
        return this.visitBreak((Statement)node);
    }

    private boolean visitBreak(Statement node) {
        try {
            String hintType;
            if (this._scopeStack.isEmpty()) {
                throw new ScopeTraceException("break without scope: " + node);
            }
            ScopeInfo scope = this._scopeStack.peek();
            if (node instanceof BreakStatement && ((BreakStatement)node).getLabel() != null) {
                return this.shouldContinue();
            }
            if (scope._statement instanceof ForStatement) {
                hintType = "break-for";
            } else if (scope._statement instanceof EnhancedForStatement) {
                hintType = "break-foreach";
            } else if (scope._statement instanceof WhileStatement) {
                hintType = "break-while";
            } else if (scope._statement instanceof DoStatement) {
                hintType = "break-do";
            } else if (scope._statement instanceof SwitchCase) {
                hintType = "break-case";
            } else {
                throw new ScopeTraceException("Unexpect scope (" + scope._statement + ") on break/continue:" + node);
            }
            int endLoc = node.getStartPosition() + node.getLength() - 1;
            this._container.add(new Hint(hintType, scope._offset, endLoc, scope._str));
        }
        catch (ScopeTraceException scopeTraceException) {
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public boolean visit(TypeDeclaration node) {
        String hint = node.getName().getIdentifier();
        int startLoc = node.getName().getStartPosition();
        int endLoc = node.getStartPosition() + node.getLength() - 1;
        try {
            this._container.add(new Hint("type", startLoc, endLoc, hint));
            this.addBrackets(node.typeParameters());
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public boolean visit(MethodDeclaration node) {
        this._scopeStack.clear();
        StringBuffer hint = new StringBuffer();
        hint.append(node.getName().getIdentifier());
        hint.append("( ");
        Iterator iterator = node.parameters().iterator();
        while (iterator.hasNext()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)iterator.next();
            hint.append(param.getName());
            if (!iterator.hasNext()) continue;
            hint.append(", ");
        }
        hint.append(" )");
        int startLoc = node.getName().getStartPosition();
        int endLoc = node.getStartPosition() + node.getLength() - 1;
        try {
            this._container.add(new Hint("function", startLoc, endLoc, hint.toString()));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public boolean visit(ForStatement node) {
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        hint = "for( " + hint + " )";
        int startLoc = node.getStartPosition();
        int endLoc = startLoc + node.getLength() - 1;
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (Statement)node));
        try {
            this._container.add(new Hint("for", startLoc, endLoc, hint));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public void endVisit(ForStatement node) {
        this.removeFromStack((Statement)node);
        super.endVisit(node);
    }

    public boolean visit(EnhancedForStatement node) {
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        int startLoc = node.getStartPosition();
        int endLoc = startLoc + node.getLength() - 1;
        hint = "foreach( " + hint + " )";
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (Statement)node));
        try {
            this._container.add(new Hint("foreach", startLoc, endLoc, hint));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public void endVisit(EnhancedForStatement node) {
        this.removeFromStack((Statement)node);
        super.endVisit(node);
    }

    public boolean visit(SwitchStatement node) {
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        int startLoc = node.getStartPosition();
        int endLoc = startLoc + node.getLength() - 1;
        hint = "switch( " + hint + " )";
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (Statement)node));
        try {
            this._container.add(new Hint("switch", startLoc, endLoc, hint));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public void endVisit(SwitchStatement node) {
        this.removeFromStack((Statement)node);
        super.endVisit(node);
    }

    public boolean visit(WhileStatement node) {
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        int startLoc = node.getStartPosition();
        int endLoc = startLoc + node.getLength() - 1;
        hint = "while( " + hint + " )";
        this._scopeStack.push(new ScopeInfo(hint, startLoc, (Statement)node));
        try {
            this._container.add(new Hint("while", startLoc, endLoc, hint));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public void endVisit(WhileStatement node) {
        this.removeFromStack((Statement)node);
        super.endVisit(node);
    }

    public boolean visit(SynchronizedStatement node) {
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        int startLoc = node.getStartPosition();
        int endLoc = startLoc + node.getLength() - 1;
        try {
            this._container.add(new Hint("synchronized", startLoc, endLoc, "synchronized( " + hint + " )"));
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    public boolean visit(IfStatement node) {
        Statement thenStmt = node.getThenStatement();
        Statement elseStmt = node.getElseStatement();
        String hint = this.GetNodeText((ASTNode)node.getExpression());
        boolean showIfHint = elseStmt == null;
        int endLoc = -1;
        try {
            int startLoc;
            if (!showIfHint) {
                if (this._doc.getLineOfOffset(elseStmt.getStartPosition()) != this._doc.getLineOfOffset(thenStmt.getStartPosition() + thenStmt.getLength())) {
                    showIfHint = true;
                }
                if (!showIfHint && !(elseStmt instanceof IfStatement)) {
                    endLoc = elseStmt.getStartPosition();
                    showIfHint = true;
                }
            }
            if (showIfHint && !(thenStmt instanceof Block)) {
                showIfHint = false;
            }
            if (showIfHint) {
                if (endLoc == -1) {
                    endLoc = thenStmt.getStartPosition() + thenStmt.getLength() - 1;
                }
                startLoc = node.getStartPosition();
                this._container.add(new Hint("if", startLoc, endLoc, "if( " + hint + " )"));
            }
            if (elseStmt != null && !(elseStmt instanceof IfStatement) && elseStmt instanceof Block) {
                endLoc = elseStmt.getStartPosition() + elseStmt.getLength() - 1;
                startLoc = elseStmt.getStartPosition();
                this._container.add(new Hint("if", startLoc, endLoc, "else_of_if( " + hint + " )"));
            }
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
        return this.shouldContinue();
    }

    private String GetNodeText(ASTNode node) {
        if (node == null) {
            return "";
        }
        try {
            return this._doc.get(node.getStartPosition(), node.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private boolean shouldContinue() {
        return !this._cancelProcessing.get();
    }

    class ScopeInfo {
        public String _str;
        public int _offset;
        public Statement _statement;

        public ScopeInfo(String str, int offset, Statement statement) {
            this._str = str;
            this._offset = offset;
            this._statement = statement;
        }
    }

    public class ScopeTraceException
    extends Exception {
        private static final long serialVersionUID = 6297837237586982280L;

        public ScopeTraceException(String message) {
            super(message);
        }
    }
}

