/*
 * Decompiled with CFR 0.152.
 */
package com.chookapp.org.bracketeer.jdt;

import com.chookapp.org.bracketeer.common.BracketsPair;
import com.chookapp.org.bracketeer.common.IBracketeerProcessingContainer;
import com.chookapp.org.bracketeer.common.SingleBracket;
import com.chookapp.org.bracketeer.common.Utils;
import com.chookapp.org.bracketeer.extensionpoint.BracketeerProcessor;
import com.chookapp.org.bracketeer.jdt.ClosingBracketHintVisitor;
import com.chookapp.org.bracketeer.jdt.core.internal.JavaPairMatcher;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class BracketeerJdtProcessor
extends BracketeerProcessor {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected static final String LONELY_BRACKETS = "()[]{}";
    String[] ALL_JPARTITIONS = new String[]{"__java_character", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string"};
    private JavaPairMatcher _matcher = new JavaPairMatcher(BRACKETS);
    private ITypeRoot _typeRoot;

    protected BracketeerJdtProcessor(IEditorPart part, IDocument doc) {
        super(doc);
        this._typeRoot = JavaUI.getEditorInputTypeRoot((IEditorInput)part.getEditorInput());
    }

    protected void processDocument(IDocument doc, IBracketeerProcessingContainer container) {
        try {
            this.processBrackets(doc, container);
            this.processAst(doc, container);
        }
        catch (BadLocationException badLocationException) {
            this._cancelProcessing.set(true);
        }
    }

    private void processAst(IDocument doc, IBracketeerProcessingContainer container) {
        if (this._typeRoot == null) {
            return;
        }
        ASTParser astp = ASTParser.newParser((int)3);
        astp.setSource(this._typeRoot);
        astp.setResolveBindings(false);
        CompilationUnit cu = (CompilationUnit)astp.createAST(null);
        ClosingBracketHintVisitor visitor = new ClosingBracketHintVisitor(container, doc, this._cancelProcessing, this._hintConf);
        cu.accept((ASTVisitor)visitor);
    }

    private void processBrackets(IDocument doc, IBracketeerProcessingContainer container) throws BadLocationException {
        int i = 1;
        while (i < doc.getLength()) {
            if (this._cancelProcessing.get()) break;
            BracketsPair pair = this.getMatchingPair(doc, i);
            if (pair != null) {
                container.add(pair);
            } else {
                SingleBracket single = this.getLonelyBracket(doc, i);
                if (single != null) {
                    container.add(single);
                }
            }
            ++i;
        }
    }

    private SingleBracket getLonelyBracket(IDocument doc, int offset) throws BadLocationException {
        int charOffset = offset - 1;
        char prevChar = doc.getChar(Math.max(charOffset, 0));
        if (LONELY_BRACKETS.indexOf(prevChar) == -1) {
            return null;
        }
        String partition = TextUtilities.getContentType((IDocument)doc, (String)"___java_partitioning", (int)charOffset, (boolean)false);
        String[] stringArray = this.ALL_JPARTITIONS;
        int n = this.ALL_JPARTITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String partName = stringArray[n2];
            if (partName.equals(partition)) {
                return null;
            }
            ++n2;
        }
        return new SingleBracket(charOffset, Utils.isOpenningBracket((char)prevChar), prevChar);
    }

    private BracketsPair getMatchingPair(IDocument doc, int offset) throws BadLocationException {
        IRegion region = this._matcher.match(doc, offset);
        if (region == null) {
            return null;
        }
        if (region.getLength() < 1) {
            throw new RuntimeException("length is less than 1");
        }
        boolean isAnchorOpening = 1 == this._matcher.getAnchor();
        int targetOffset = isAnchorOpening ? region.getOffset() + region.getLength() : region.getOffset() + 1;
        --offset;
        --targetOffset;
        if (isAnchorOpening) {
            return new BracketsPair(offset, doc.getChar(offset), targetOffset, doc.getChar(targetOffset));
        }
        return new BracketsPair(targetOffset, doc.getChar(targetOffset), offset, doc.getChar(offset));
    }
}

