#!/bin/sh

DIR=$1; shift
FILELIST=$1; shift
LOFILELIST=$1 ; shift
TARGET=$1; shift
STATIC=$1; shift
AR=$1; shift
RANLIB=$1; shift

HEADER="# Generated by Martin's tool $0, not libtool"

test -f $TARGET && exit 0

rm -f $FILELIST
rm -f $LOFILELIST

while [ "$1" != "--" ]; do
	file=$1; shift
	filename=`basename $file`
	LOFILE=$file.lo
	echo "$HEADER" > $LOFILE
	if [ "$STATIC" = "static" ]; then
		echo "non_pic_object='$filename'" >> $LOFILE
	else
		echo "pic_object='$filename'" >> $LOFILE
	fi
	echo "$DIR/$file " >> $FILELIST
	echo "$DIR/$LOFILE " >> $LOFILELIST
done

(cd $DIR && $AR cr $TARGET `cat $FILELIST` && $RANLIB $TARGET)

