﻿using MediaBrowser.Controller.Channels;
using MediaBrowser.Controller.Entities;
using MediaBrowser.Controller.Providers;
using MediaBrowser.Model.Entities;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Emby.Server.Implementations.Channels
{
    public class ChannelImageProvider : IDynamicImageProvider, IHasItemChangeMonitor
    {
        private readonly IChannelManager _channelManager;

        public ChannelImageProvider(IChannelManager channelManager)
        {
            _channelManager = channelManager;
        }

        public IEnumerable<ImageType> GetSupportedImages(IHasMetadata item)
        {
            return GetChannel(item).GetSupportedChannelImages();
        }

        public Task<DynamicImageResponse> GetImage(IHasMetadata item, ImageType type, CancellationToken cancellationToken)
        {
            var channel = GetChannel(item);

            return channel.GetChannelImage(type, cancellationToken);
        }

        public string Name
        {
            get { return "Channel Image Provider"; }
        }

        public bool Supports(IHasMetadata item)
        {
            return item is Channel;
        }

        private IChannel GetChannel(IHasMetadata item)
        {
            var channel = (Channel)item;

            return ((ChannelManager)_channelManager).GetChannelProvider(channel);
        }

        public bool HasChanged(IHasMetadata item, IDirectoryService directoryService)
        {
            return GetSupportedImages(item).Any(i => !item.HasImage(i));
        }
    }
}
