/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Private declairations used by internal VU support routines.
 */

#include <worldvu/vu.h>

typedef struct  region
{
    VUPORT  r_vu;
    CITEM   *r_ctrl;
    EVENT   r_event;
    PARM    r_p1, r_p2;
    BOOL    r_rpos;
    RECT    r_region;
}   REGION;

typedef struct  eventq
{
    VUPORT  evport;
    EVENT   event;
    PARM    ev_p1,ev_p2;
}   EVENTQ;

typedef struct  redrawq
{
    EVENT   redmode;
    VUPORT  redvu;      /* or null */
    RECT    redrc;
}   REDRAWQ;

typedef struct  queue
{
    int     qsize;
    int     qhead;
    int     qtail;
}   QUEUE;

typedef struct                      /* internal user preference record */
{
    long    prefnext;               /* next linked preference record */
    int     prefid;                 /* preference id type (0==desktop) */
    char    prefs[64];              /* 64 byte preference record */
}   VUPREFDATA;

typedef struct                      /* preference user header record */
{
    long    preflink;               /* next hash and scavange entry */
    time_t  prefset,prefchk;        /* last access times */
    long    prefdata;               /* link to data */
    char    prefuser[18];           /* user id */
}   VUPREFUSER;

typedef struct
{
    char    prefsysid[4];           /* pref file identifier */
    long    prefhash[255];          /* hash table by user id */
    long    prefscavange;           /* scavanger list */
    long    prefdatafree;           /* data records freed by scavanger */
}   VUPREFHDR;

/*  system build constants */

#define MAXEVQ  16          /* maximum event queue size */
#define MAXRDQ  16          /* maximum redraw queue size */

extern  time_t  _login_time,_event_time;

