/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

#define __MULTINATIONAL
#define NR_DEFAULT  NR_ENGLISH
#define NR_DEFAULT_LANG "LANG=english_us"
#define NR_DATE_FORMAT  0
#define NR_TIME_FORMAT  0
#define NR_ABBRV_FORMAT 0
#define NR_SUPPORT  0x000F  /* 0x0008 = spanish mask */
#define NR_COUNT    4   /* count 4 with spanish */

/*  define translated vector resources  */

enum
{
    NR_ENGLISH = 0,
    NR_ITALIAN,
    NR_ROMANIAN,
    NR_CZECH,
    NR_NONE
};

extern  int replacement_language;
extern  unsigned    long    replacement_support[];
extern  int vu_national_date;
extern  int vu_national_time;
extern  int vu_national_abbrv;

#define REPLACE_ENGLISH(str, a)         {CINV,       str,0,0,0,0, NR_ENGLISH, 0, a},
#define REPLACE_ITALIAN(str, a)         {CINV,       str,0,0,0,0, NR_ITALIAN, 0, a},
#define REPLACE_ROMANIAN(str, a)        {CINV,  str,0,0,0,0, NR_ROMANIAN, 0, a},
#define REPLACE_CZECH(str, a)           {CINV,  str,0,0,0,0, NR_CZECH, 0, a},
#define REPLACE_DEFAULT()           {CINV,  NULL,0,0,0,0,-1,          0,NULL},

#define VU_MARKER_CELL  0x7f

IMPORT  void    GetVUMulti(int nr);
IMPORT  unsigned char VUToLower(unsigned char c);
IMPORT  unsigned char VUToUpper(unsigned char c);
IMPORT  char    *VUStrLower(STRING s);
IMPORT  char    *VUStrUpper(STRING s);
IMPORT  char    *VUStrProper(STRING s);
IMPORT  int VUStrcmp(const STRING s1, const STRING s2);
IMPORT  int VUStrncmp(const STRING s1, const STRING s2, int len);
IMPORT  int VUStricmp(const STRING s1, const STRING s2);
IMPORT  int VUStrnicmp(const STRING s1, const STRING s2, int len);
IMPORT  BOOL    VUStrTrue(STRING s);
IMPORT  BOOL    VUValidText(unsigned char c);

IMPORT  char    *VUMultiDow(int d, BOOL abbr);
IMPORT  char    *VUMultiMonth(int m, BOOL abbr);
IMPORT  char    *VUDateDMY(time_t *time);
IMPORT  char    *VUDateMDY(time_t *time);
IMPORT  int VUMultiCentury(time_t *time);
IMPORT  struct  tm* VULocalTime(time_t *time);
IMPORT  STRING  VUTextString(STRING s);
IMPORT  STRING  VUTextCtrlString(STRING s);
IMPORT  int VULoadMsgText(char *id, char **msgs, int count);
IMPORT  int VUStrLength(STRING s);
IMPORT  char    *VUShortDate(time_t *time);
IMPORT  char    *VUMixedDate(time_t *time);
IMPORT  char    *VUUnixDate(time_t *time);
IMPORT  char    *VULongDate(time_t *time);


