/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Defines constants used for function and other special keys.
 */

#define KEY_REV_TAB     0x380
#define KEY_F1          0x281   /* F1 through F30 are contiguous, F1 + n-1 ...*/
#define KEY_F2          0x282
#define KEY_F3          0x283
#define KEY_F4          0x284
#define KEY_F5          0x285
#define KEY_F6          0x286
#define KEY_F7          0x287
#define KEY_F8          0x288
#define KEY_F9          0x289
#define KEY_F10         0x28A
#define KEY_F11         0x28B
#define KEY_F12         0x28C
#define KEY_F30         0x29e
#define KEY_HOME        0x381
#define KEY_UP          0x382
#define KEY_PAGEUP      0x383
#define KEY_CANCEL      0x384
#define KEY_LEFT        0x385
#define KEY_RIGHT       0x386
#define KEY_SELECT      0x387
#define KEY_END         0x388
#define KEY_DOWN        0x389
#define KEY_PAGEDOWN    0x38A
#define KEY_INSERT      0x38B
#define KEY_DELETE      0x38C

#define KEY_HELP        0x481
#define KEY_FIND        0x482
#define KEY_COPY        0x483
#define KEY_OPEN        0x484
#define KEY_CLOSE       0x485
#define KEY_PRTSC       0x486
#define KEY_SYSREQ      0x487
#define KEY_REFRESH     0x488
#define KEY_WHO         0x489
#define KEY_FINGER      0x48a
#define KEY_PAGE        0x48b
#define KEY_TALK        0x48c
#define KEY_BOOKMARK        0x48d
#define KEY_ACTIVE      0x48e

/*  OS key translations */

#ifdef  QNX
#define KEY_ENTER       0x1E        /* QNX newline code */
#endif

/*  default key codes   */

#ifndef KEY_ENTER
#define KEY_ENTER       13
#endif

#ifndef KEY_TAB
#define KEY_TAB         9
#endif

#ifndef KEY_RUBOUT
#define KEY_RUBOUT      0x7F
#endif

#ifndef KEY_EXIT
#define KEY_EXIT        0x1B
#endif

#ifndef KEY_ERASE
#define KEY_ERASE       0x18
#endif


