/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *  Diskette based operations through VU interface.
 */

#ifndef __VU_H__
#include <vu/vu.h>
#endif

#define DISK_EXIT_SUCCESS   0
#define DISK_EXIT_FAILURE   1
#define DISK_EXIT_ABORTED   2

typedef struct {
    char    fd_device[8];
    char    fd_text[40];
    char    fd_skip;
    char    fd_heads;
    short   fd_tracks;
    short   fd_sectors;
    short   fd_block;
    short   fd_devno;
} FDFORMAT;

typedef struct {
    BOOL    dsk_timer_save;
    short   dsk_status;
    short   dsk_track;
    long    dsk_block;
} *DISKOPTS;

extern  FDFORMAT    fd_fmttab[];
extern  int     fd_fmtcnt;
extern  char        fd_fmt_title[];
extern  char        fd_fmt_text[];
extern  char        fd_fmt_format[];

WINDOW(VUFormatDisk);
PORT(VUFormatDiskPort);



