#.rst:
# CapeConfig
# ---------------

#=============================================================================
# Copyright (C) 2015 David Sugar, Tycho Softworks.
#
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#=============================================================================

include(GNUInstallDirs)
include(CheckFunctionExists)
include(CheckIncludeFiles)

macro(cpr_check_functions)
    foreach(arg ${ARGN})
        string(TOUPPER "${arg}" _fn)
        set(_fn "HAVE_${_fn}")
        check_function_exists(${arg} ${_fn})
    endforeach()
endmacro()

macro(cpr_check_headers)
    foreach(arg ${ARGN})
        string(TOUPPER "${arg}" _hdr)
        string(REGEX REPLACE "/" "_" _hdr ${_hdr})
        string(REGEX REPLACE "[.]" "_" _hdr ${_hdr})
        set(_hdr "HAVE_${_hdr}")
        check_include_files(${arg} ${_hdr})
    endforeach()
endmacro()

function(cpr_library_version _LIBRARY)
    set(_VERSION "${ARGN}")
    set(_SOVERSION "-")
	if(NOT UNIX OR "${_VERSION}" STREQUAL "")
		set(_VERSION "${VERSION}")
	endif()
	STRING(REGEX REPLACE "[.].*$" "" _SOVERSION ${_VERSION})
	if(ABI_MAJORONLY)
		set(_VERSION ${_SOVERSION})
	endif()
    set_target_properties(${_LIBRARY} PROPERTIES VERSION ${_VERSION} SOVERSION ${_SOVERSION})
endfunction()

function(cpr_source_dependencies _TARGET)
    if(NOT "${CMAKE_SOURCE_DIR}" STREQUAL "${PROJECT_SOURCE_DIR}")
        add_dependencies(${_TARGET} ${ARGN})
    endif()
endfunction()

function(cpr_create_specfile)
    configure_file(${CMAKE_CURRENT_SOURCE_DIR}/${PROJECT_NAME}.spec.cmake ${CMAKE_CURRENT_SOURCE_DIR}/${PROJECT_NAME}.spec @ONLY)
endfunction()

function(cpr_create_scripts _OUTPUT)
    set(SCR_FILES)
    foreach(arg ${ARGN})
        configure_file(${CMAKE_CURRENT_SOURCE_DIR}/${arg}.cmake ${CMAKE_CURRENT_BINARY_DIR}/${arg})
        set(SCR_FILES ${SCR_FILES} ${CMAKE_CURRENT_BINARY_DIR}/${arg})
    endforeach()
    set(${_OUTPUT} ${SCR_FILES} PARENT_SCOPE)
endfunction()

function(cpr_create_pcfiles _OUTPUT)
    set(PC_FILES)
    foreach(arg ${ARGN})
        configure_file(${CMAKE_CURRENT_SOURCE_DIR}/${arg}.pc.cmake ${CMAKE_CURRENT_BINARY_DIR}/${arg}.pc)
        set(PC_FILES ${PC_FILES} ${CMAKE_CURRENT_BINARY_DIR}/${arg}.pc)
    endforeach()
    set(${_OUTPUT} ${PC_FILES} PARENT_SCOPE)
endfunction()

function(cpr_create_headers)
    if(ARGN)
        foreach(arg ${ARGN})
            configure_file(${CMAKE_CURRENT_SOURCE_DIR}/${arg}.cmake ${CMAKE_CURRENT_BINARY_DIR}/${arg})
        endforeach()
    else()
        configure_file(${CMAKE_CURRENT_SOURCE_DIR}/${PROJECT_NAME}-config.h.cmake ${CMAKE_CURRENT_BINARY_DIR}/${PROJECT_NAME}-config.h)
    endif()
    include_directories(${CMAKE_CURRENT_BINARY_DIR})
endfunction()

