/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTDecRefQueue;
import com.microsoft.z3.ASTMapDecRefQueue;
import com.microsoft.z3.ASTVectorDecRefQueue;
import com.microsoft.z3.ApplyResultDecRefQueue;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Constructor;
import com.microsoft.z3.ConstructorList;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FPExpr;
import com.microsoft.z3.FPNum;
import com.microsoft.z3.FPRMExpr;
import com.microsoft.z3.FPRMNum;
import com.microsoft.z3.FPRMSort;
import com.microsoft.z3.FPSort;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.Fixedpoint;
import com.microsoft.z3.FixedpointDecRefQueue;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterpDecRefQueue;
import com.microsoft.z3.FuncInterpEntryDecRefQueue;
import com.microsoft.z3.Goal;
import com.microsoft.z3.GoalDecRefQueue;
import com.microsoft.z3.IDecRefQueue;
import com.microsoft.z3.IDisposable;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.ListSort;
import com.microsoft.z3.ModelDecRefQueue;
import com.microsoft.z3.Native;
import com.microsoft.z3.Optimize;
import com.microsoft.z3.OptimizeDecRefQueue;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.ParamDescrsDecRefQueue;
import com.microsoft.z3.Params;
import com.microsoft.z3.ParamsDecRefQueue;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Probe;
import com.microsoft.z3.ProbeDecRefQueue;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.SetSort;
import com.microsoft.z3.Solver;
import com.microsoft.z3.SolverDecRefQueue;
import com.microsoft.z3.Sort;
import com.microsoft.z3.StatisticsDecRefQueue;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.TacticDecRefQueue;
import com.microsoft.z3.TupleSort;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.util.Map;

public class Context
extends IDisposable {
    private BoolSort m_boolSort = null;
    private IntSort m_intSort = null;
    private RealSort m_realSort = null;
    long m_ctx = 0L;
    private ASTDecRefQueue m_AST_DRQ = new ASTDecRefQueue();
    private ASTMapDecRefQueue m_ASTMap_DRQ = new ASTMapDecRefQueue(10);
    private ASTVectorDecRefQueue m_ASTVector_DRQ = new ASTVectorDecRefQueue(10);
    private ApplyResultDecRefQueue m_ApplyResult_DRQ = new ApplyResultDecRefQueue(10);
    private FuncInterpEntryDecRefQueue m_FuncEntry_DRQ = new FuncInterpEntryDecRefQueue(10);
    private FuncInterpDecRefQueue m_FuncInterp_DRQ = new FuncInterpDecRefQueue(10);
    private GoalDecRefQueue m_Goal_DRQ = new GoalDecRefQueue(10);
    private ModelDecRefQueue m_Model_DRQ = new ModelDecRefQueue(10);
    private ParamsDecRefQueue m_Params_DRQ = new ParamsDecRefQueue(10);
    private ParamDescrsDecRefQueue m_ParamDescrs_DRQ = new ParamDescrsDecRefQueue(10);
    private ProbeDecRefQueue m_Probe_DRQ = new ProbeDecRefQueue(10);
    private SolverDecRefQueue m_Solver_DRQ = new SolverDecRefQueue(10);
    private StatisticsDecRefQueue m_Statistics_DRQ = new StatisticsDecRefQueue(10);
    private TacticDecRefQueue m_Tactic_DRQ = new TacticDecRefQueue(10);
    private FixedpointDecRefQueue m_Fixedpoint_DRQ = new FixedpointDecRefQueue(10);
    private OptimizeDecRefQueue m_Optimize_DRQ = new OptimizeDecRefQueue(10);
    protected long m_refCount = 0L;

    public Context() {
        this.m_ctx = Native.mkContextRc(0L);
        this.initContext();
    }

    public Context(Map<String, String> map) {
        long l = Native.mkConfig();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Native.setParamValue(l, entry.getKey(), entry.getValue());
        }
        this.m_ctx = Native.mkContextRc(l);
        Native.delConfig(l);
        this.initContext();
    }

    public IntSymbol mkSymbol(int n) {
        return new IntSymbol(this, n);
    }

    public StringSymbol mkSymbol(String string) {
        return new StringSymbol(this, string);
    }

    Symbol[] mkSymbols(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Symbol[] symbolArray = new Symbol[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            symbolArray[i] = this.mkSymbol(stringArray[i]);
        }
        return symbolArray;
    }

    public BoolSort getBoolSort() {
        if (this.m_boolSort == null) {
            this.m_boolSort = new BoolSort(this);
        }
        return this.m_boolSort;
    }

    public IntSort getIntSort() {
        if (this.m_intSort == null) {
            this.m_intSort = new IntSort(this);
        }
        return this.m_intSort;
    }

    public RealSort getRealSort() {
        if (this.m_realSort == null) {
            this.m_realSort = new RealSort(this);
        }
        return this.m_realSort;
    }

    public BoolSort mkBoolSort() {
        return new BoolSort(this);
    }

    public UninterpretedSort mkUninterpretedSort(Symbol symbol) {
        this.checkContextMatch(symbol);
        return new UninterpretedSort(this, symbol);
    }

    public UninterpretedSort mkUninterpretedSort(String string) {
        return this.mkUninterpretedSort(this.mkSymbol(string));
    }

    public IntSort mkIntSort() {
        return new IntSort(this);
    }

    public RealSort mkRealSort() {
        return new RealSort(this);
    }

    public BitVecSort mkBitVecSort(int n) {
        return new BitVecSort(this, Native.mkBvSort(this.nCtx(), n));
    }

    public ArraySort mkArraySort(Sort sort, Sort sort2) {
        this.checkContextMatch(sort);
        this.checkContextMatch(sort2);
        return new ArraySort(this, sort, sort2);
    }

    public TupleSort mkTupleSort(Symbol symbol, Symbol[] symbolArray, Sort[] sortArray) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(symbolArray);
        this.checkContextMatch(sortArray);
        return new TupleSort(this, symbol, symbolArray.length, symbolArray, sortArray);
    }

    public EnumSort mkEnumSort(Symbol symbol, Symbol ... symbolArray) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(symbolArray);
        return new EnumSort(this, symbol, symbolArray);
    }

    public EnumSort mkEnumSort(String string, String ... stringArray) {
        return new EnumSort(this, this.mkSymbol(string), this.mkSymbols(stringArray));
    }

    public ListSort mkListSort(Symbol symbol, Sort sort) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sort);
        return new ListSort(this, symbol, sort);
    }

    public ListSort mkListSort(String string, Sort sort) {
        this.checkContextMatch(sort);
        return new ListSort(this, this.mkSymbol(string), sort);
    }

    public FiniteDomainSort mkFiniteDomainSort(Symbol symbol, long l) {
        this.checkContextMatch(symbol);
        return new FiniteDomainSort(this, symbol, l);
    }

    public FiniteDomainSort mkFiniteDomainSort(String string, long l) {
        return new FiniteDomainSort(this, this.mkSymbol(string), l);
    }

    public Constructor mkConstructor(Symbol symbol, Symbol symbol2, Symbol[] symbolArray, Sort[] sortArray, int[] nArray) {
        return new Constructor(this, symbol, symbol2, symbolArray, sortArray, nArray);
    }

    public Constructor mkConstructor(String string, String string2, String[] stringArray, Sort[] sortArray, int[] nArray) {
        return new Constructor(this, this.mkSymbol(string), this.mkSymbol(string2), this.mkSymbols(stringArray), sortArray, nArray);
    }

    public DatatypeSort mkDatatypeSort(Symbol symbol, Constructor[] constructorArray) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(constructorArray);
        return new DatatypeSort(this, symbol, constructorArray);
    }

    public DatatypeSort mkDatatypeSort(String string, Constructor[] constructorArray) {
        this.checkContextMatch(constructorArray);
        return new DatatypeSort(this, this.mkSymbol(string), constructorArray);
    }

    public DatatypeSort[] mkDatatypeSorts(Symbol[] symbolArray, Constructor[][] constructorArray) {
        Z3Object[] z3ObjectArray;
        this.checkContextMatch(symbolArray);
        int n = symbolArray.length;
        ConstructorList[] constructorListArray = new ConstructorList[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            z3ObjectArray = constructorArray[i];
            this.checkContextMatch(z3ObjectArray);
            constructorListArray[i] = new ConstructorList(this, (Constructor[])z3ObjectArray);
            lArray[i] = constructorListArray[i].getNativeObject();
        }
        long[] lArray2 = new long[n];
        Native.mkDatatypes(this.nCtx(), n, Symbol.arrayToNative(symbolArray), lArray2, lArray);
        z3ObjectArray = new DatatypeSort[n];
        for (int i = 0; i < n; ++i) {
            z3ObjectArray[i] = new DatatypeSort(this, lArray2[i]);
        }
        return z3ObjectArray;
    }

    public DatatypeSort[] mkDatatypeSorts(String[] stringArray, Constructor[][] constructorArray) {
        return this.mkDatatypeSorts(this.mkSymbols(stringArray), constructorArray);
    }

    public Expr MkUpdateField(FuncDecl funcDecl, Expr expr, Expr expr2) throws Z3Exception {
        return Expr.create(this, Native.datatypeUpdateField(this.nCtx(), funcDecl.getNativeObject(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public FuncDecl mkFuncDecl(Symbol symbol, Sort[] sortArray, Sort sort) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sortArray);
        this.checkContextMatch(sort);
        return new FuncDecl(this, symbol, sortArray, sort);
    }

    public FuncDecl mkFuncDecl(Symbol symbol, Sort sort, Sort sort2) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sort);
        this.checkContextMatch(sort2);
        Sort[] sortArray = new Sort[]{sort};
        return new FuncDecl(this, symbol, sortArray, sort2);
    }

    public FuncDecl mkFuncDecl(String string, Sort[] sortArray, Sort sort) {
        this.checkContextMatch(sortArray);
        this.checkContextMatch(sort);
        return new FuncDecl(this, this.mkSymbol(string), sortArray, sort);
    }

    public FuncDecl mkFuncDecl(String string, Sort sort, Sort sort2) {
        this.checkContextMatch(sort);
        this.checkContextMatch(sort2);
        Sort[] sortArray = new Sort[]{sort};
        return new FuncDecl(this, this.mkSymbol(string), sortArray, sort2);
    }

    public FuncDecl mkFreshFuncDecl(String string, Sort[] sortArray, Sort sort) {
        this.checkContextMatch(sortArray);
        this.checkContextMatch(sort);
        return new FuncDecl(this, string, sortArray, sort);
    }

    public FuncDecl mkConstDecl(Symbol symbol, Sort sort) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sort);
        return new FuncDecl(this, symbol, null, sort);
    }

    public FuncDecl mkConstDecl(String string, Sort sort) {
        this.checkContextMatch(sort);
        return new FuncDecl(this, this.mkSymbol(string), null, sort);
    }

    public FuncDecl mkFreshConstDecl(String string, Sort sort) {
        this.checkContextMatch(sort);
        return new FuncDecl(this, string, null, sort);
    }

    public Expr mkBound(int n, Sort sort) {
        return Expr.create(this, Native.mkBound(this.nCtx(), n, sort.getNativeObject()));
    }

    public Pattern mkPattern(Expr ... exprArray) {
        if (exprArray.length == 0) {
            throw new Z3Exception("Cannot create a pattern from zero terms");
        }
        long[] lArray = AST.arrayToNative(exprArray);
        return new Pattern(this, Native.mkPattern(this.nCtx(), exprArray.length, lArray));
    }

    public Expr mkConst(Symbol symbol, Sort sort) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sort);
        return Expr.create(this, Native.mkConst(this.nCtx(), symbol.getNativeObject(), sort.getNativeObject()));
    }

    public Expr mkConst(String string, Sort sort) {
        return this.mkConst(this.mkSymbol(string), sort);
    }

    public Expr mkFreshConst(String string, Sort sort) {
        this.checkContextMatch(sort);
        return Expr.create(this, Native.mkFreshConst(this.nCtx(), string, sort.getNativeObject()));
    }

    public Expr mkConst(FuncDecl funcDecl) {
        return this.mkApp(funcDecl, null);
    }

    public BoolExpr mkBoolConst(Symbol symbol) {
        return (BoolExpr)this.mkConst(symbol, (Sort)this.getBoolSort());
    }

    public BoolExpr mkBoolConst(String string) {
        return (BoolExpr)this.mkConst(this.mkSymbol(string), (Sort)this.getBoolSort());
    }

    public IntExpr mkIntConst(Symbol symbol) {
        return (IntExpr)this.mkConst(symbol, (Sort)this.getIntSort());
    }

    public IntExpr mkIntConst(String string) {
        return (IntExpr)this.mkConst(string, (Sort)this.getIntSort());
    }

    public RealExpr mkRealConst(Symbol symbol) {
        return (RealExpr)this.mkConst(symbol, (Sort)this.getRealSort());
    }

    public RealExpr mkRealConst(String string) {
        return (RealExpr)this.mkConst(string, (Sort)this.getRealSort());
    }

    public BitVecExpr mkBVConst(Symbol symbol, int n) {
        return (BitVecExpr)this.mkConst(symbol, (Sort)this.mkBitVecSort(n));
    }

    public BitVecExpr mkBVConst(String string, int n) {
        return (BitVecExpr)this.mkConst(string, (Sort)this.mkBitVecSort(n));
    }

    public Expr mkApp(FuncDecl funcDecl, Expr ... exprArray) {
        this.checkContextMatch(funcDecl);
        this.checkContextMatch(exprArray);
        return Expr.create(this, funcDecl, exprArray);
    }

    public BoolExpr mkTrue() {
        return new BoolExpr(this, Native.mkTrue(this.nCtx()));
    }

    public BoolExpr mkFalse() {
        return new BoolExpr(this, Native.mkFalse(this.nCtx()));
    }

    public BoolExpr mkBool(boolean bl) {
        return bl ? this.mkTrue() : this.mkFalse();
    }

    public BoolExpr mkEq(Expr expr, Expr expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkEq(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkDistinct(Expr ... exprArray) {
        this.checkContextMatch(exprArray);
        return new BoolExpr(this, Native.mkDistinct(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public BoolExpr mkNot(BoolExpr boolExpr) {
        this.checkContextMatch(boolExpr);
        return new BoolExpr(this, Native.mkNot(this.nCtx(), boolExpr.getNativeObject()));
    }

    public Expr mkITE(BoolExpr boolExpr, Expr expr, Expr expr2) {
        this.checkContextMatch(boolExpr);
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return Expr.create(this, Native.mkIte(this.nCtx(), boolExpr.getNativeObject(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkIff(BoolExpr boolExpr, BoolExpr boolExpr2) {
        this.checkContextMatch(boolExpr);
        this.checkContextMatch(boolExpr2);
        return new BoolExpr(this, Native.mkIff(this.nCtx(), boolExpr.getNativeObject(), boolExpr2.getNativeObject()));
    }

    public BoolExpr mkImplies(BoolExpr boolExpr, BoolExpr boolExpr2) {
        this.checkContextMatch(boolExpr);
        this.checkContextMatch(boolExpr2);
        return new BoolExpr(this, Native.mkImplies(this.nCtx(), boolExpr.getNativeObject(), boolExpr2.getNativeObject()));
    }

    public BoolExpr mkXor(BoolExpr boolExpr, BoolExpr boolExpr2) {
        this.checkContextMatch(boolExpr);
        this.checkContextMatch(boolExpr2);
        return new BoolExpr(this, Native.mkXor(this.nCtx(), boolExpr.getNativeObject(), boolExpr2.getNativeObject()));
    }

    public BoolExpr mkAnd(BoolExpr ... boolExprArray) {
        this.checkContextMatch(boolExprArray);
        return new BoolExpr(this, Native.mkAnd(this.nCtx(), boolExprArray.length, AST.arrayToNative(boolExprArray)));
    }

    public BoolExpr mkOr(BoolExpr ... boolExprArray) {
        this.checkContextMatch(boolExprArray);
        return new BoolExpr(this, Native.mkOr(this.nCtx(), boolExprArray.length, AST.arrayToNative(boolExprArray)));
    }

    public ArithExpr mkAdd(ArithExpr ... arithExprArray) {
        this.checkContextMatch(arithExprArray);
        return (ArithExpr)Expr.create(this, Native.mkAdd(this.nCtx(), arithExprArray.length, AST.arrayToNative(arithExprArray)));
    }

    public ArithExpr mkMul(ArithExpr ... arithExprArray) {
        this.checkContextMatch(arithExprArray);
        return (ArithExpr)Expr.create(this, Native.mkMul(this.nCtx(), arithExprArray.length, AST.arrayToNative(arithExprArray)));
    }

    public ArithExpr mkSub(ArithExpr ... arithExprArray) {
        this.checkContextMatch(arithExprArray);
        return (ArithExpr)Expr.create(this, Native.mkSub(this.nCtx(), arithExprArray.length, AST.arrayToNative(arithExprArray)));
    }

    public ArithExpr mkUnaryMinus(ArithExpr arithExpr) {
        this.checkContextMatch(arithExpr);
        return (ArithExpr)Expr.create(this, Native.mkUnaryMinus(this.nCtx(), arithExpr.getNativeObject()));
    }

    public ArithExpr mkDiv(ArithExpr arithExpr, ArithExpr arithExpr2) {
        this.checkContextMatch(arithExpr);
        this.checkContextMatch(arithExpr2);
        return (ArithExpr)Expr.create(this, Native.mkDiv(this.nCtx(), arithExpr.getNativeObject(), arithExpr2.getNativeObject()));
    }

    public IntExpr mkMod(IntExpr intExpr, IntExpr intExpr2) {
        this.checkContextMatch(intExpr);
        this.checkContextMatch(intExpr2);
        return new IntExpr(this, Native.mkMod(this.nCtx(), intExpr.getNativeObject(), intExpr2.getNativeObject()));
    }

    public IntExpr mkRem(IntExpr intExpr, IntExpr intExpr2) {
        this.checkContextMatch(intExpr);
        this.checkContextMatch(intExpr2);
        return new IntExpr(this, Native.mkRem(this.nCtx(), intExpr.getNativeObject(), intExpr2.getNativeObject()));
    }

    public ArithExpr mkPower(ArithExpr arithExpr, ArithExpr arithExpr2) {
        this.checkContextMatch(arithExpr);
        this.checkContextMatch(arithExpr2);
        return (ArithExpr)Expr.create(this, Native.mkPower(this.nCtx(), arithExpr.getNativeObject(), arithExpr2.getNativeObject()));
    }

    public BoolExpr mkLt(ArithExpr arithExpr, ArithExpr arithExpr2) {
        this.checkContextMatch(arithExpr);
        this.checkContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkLt(this.nCtx(), arithExpr.getNativeObject(), arithExpr2.getNativeObject()));
    }

    public BoolExpr mkLe(ArithExpr arithExpr, ArithExpr arithExpr2) {
        this.checkContextMatch(arithExpr);
        this.checkContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkLe(this.nCtx(), arithExpr.getNativeObject(), arithExpr2.getNativeObject()));
    }

    public BoolExpr mkGt(ArithExpr arithExpr, ArithExpr arithExpr2) {
        this.checkContextMatch(arithExpr);
        this.checkContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkGt(this.nCtx(), arithExpr.getNativeObject(), arithExpr2.getNativeObject()));
    }

    public BoolExpr mkGe(ArithExpr arithExpr, ArithExpr arithExpr2) {
        this.checkContextMatch(arithExpr);
        this.checkContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkGe(this.nCtx(), arithExpr.getNativeObject(), arithExpr2.getNativeObject()));
    }

    public RealExpr mkInt2Real(IntExpr intExpr) {
        this.checkContextMatch(intExpr);
        return new RealExpr(this, Native.mkInt2real(this.nCtx(), intExpr.getNativeObject()));
    }

    public IntExpr mkReal2Int(RealExpr realExpr) {
        this.checkContextMatch(realExpr);
        return new IntExpr(this, Native.mkReal2int(this.nCtx(), realExpr.getNativeObject()));
    }

    public BoolExpr mkIsInteger(RealExpr realExpr) {
        this.checkContextMatch(realExpr);
        return new BoolExpr(this, Native.mkIsInt(this.nCtx(), realExpr.getNativeObject()));
    }

    public BitVecExpr mkBVNot(BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvnot(this.nCtx(), bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVRedAND(BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvredand(this.nCtx(), bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVRedOR(BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvredor(this.nCtx(), bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVAND(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvand(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvor(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVXOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvxor(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVNAND(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvnand(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVNOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvnor(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVXNOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvxnor(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVNeg(BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvneg(this.nCtx(), bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVAdd(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvadd(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVSub(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsub(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVMul(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvmul(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVUDiv(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvudiv(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVSDiv(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsdiv(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVURem(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvurem(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVSRem(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsrem(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVSMod(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsmod(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVULT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvult(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVSLT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvslt(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVULE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvule(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVSLE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsle(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVUGE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvuge(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVSGE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsge(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVUGT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvugt(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVSGT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsgt(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkConcat(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkConcat(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkExtract(int n, int n2, BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkExtract(this.nCtx(), n, n2, bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkSignExt(int n, BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkSignExt(this.nCtx(), n, bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkZeroExt(int n, BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkZeroExt(this.nCtx(), n, bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkRepeat(int n, BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkRepeat(this.nCtx(), n, bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVSHL(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvshl(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVLSHR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvlshr(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVASHR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvashr(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVRotateLeft(int n, BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkRotateLeft(this.nCtx(), n, bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVRotateRight(int n, BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkRotateRight(this.nCtx(), n, bitVecExpr.getNativeObject()));
    }

    public BitVecExpr mkBVRotateLeft(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkExtRotateLeft(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkBVRotateRight(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkExtRotateRight(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BitVecExpr mkInt2BV(int n, IntExpr intExpr) {
        this.checkContextMatch(intExpr);
        return new BitVecExpr(this, Native.mkInt2bv(this.nCtx(), n, intExpr.getNativeObject()));
    }

    public IntExpr mkBV2Int(BitVecExpr bitVecExpr, boolean bl) {
        this.checkContextMatch(bitVecExpr);
        return new IntExpr(this, Native.mkBv2int(this.nCtx(), bitVecExpr.getNativeObject(), bl));
    }

    public BoolExpr mkBVAddNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, boolean bl) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvaddNoOverflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject(), bl));
    }

    public BoolExpr mkBVAddNoUnderflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvaddNoUnderflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVSubNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsubNoOverflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVSubNoUnderflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, boolean bl) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsubNoUnderflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject(), bl));
    }

    public BoolExpr mkBVSDivNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsdivNoOverflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public BoolExpr mkBVNegNoOverflow(BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return new BoolExpr(this, Native.mkBvnegNoOverflow(this.nCtx(), bitVecExpr.getNativeObject()));
    }

    public BoolExpr mkBVMulNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, boolean bl) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvmulNoOverflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject(), bl));
    }

    public BoolExpr mkBVMulNoUnderflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) {
        this.checkContextMatch(bitVecExpr);
        this.checkContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvmulNoUnderflow(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject()));
    }

    public ArrayExpr mkArrayConst(Symbol symbol, Sort sort, Sort sort2) {
        return (ArrayExpr)this.mkConst(symbol, (Sort)this.mkArraySort(sort, sort2));
    }

    public ArrayExpr mkArrayConst(String string, Sort sort, Sort sort2) {
        return (ArrayExpr)this.mkConst(this.mkSymbol(string), (Sort)this.mkArraySort(sort, sort2));
    }

    public Expr mkSelect(ArrayExpr arrayExpr, Expr expr) {
        this.checkContextMatch(arrayExpr);
        this.checkContextMatch(expr);
        return Expr.create(this, Native.mkSelect(this.nCtx(), arrayExpr.getNativeObject(), expr.getNativeObject()));
    }

    public ArrayExpr mkStore(ArrayExpr arrayExpr, Expr expr, Expr expr2) {
        this.checkContextMatch(arrayExpr);
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new ArrayExpr(this, Native.mkStore(this.nCtx(), arrayExpr.getNativeObject(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public ArrayExpr mkConstArray(Sort sort, Expr expr) {
        this.checkContextMatch(sort);
        this.checkContextMatch(expr);
        return new ArrayExpr(this, Native.mkConstArray(this.nCtx(), sort.getNativeObject(), expr.getNativeObject()));
    }

    public ArrayExpr mkMap(FuncDecl funcDecl, ArrayExpr ... arrayExprArray) {
        this.checkContextMatch(funcDecl);
        this.checkContextMatch(arrayExprArray);
        return (ArrayExpr)Expr.create(this, Native.mkMap(this.nCtx(), funcDecl.getNativeObject(), AST.arrayLength(arrayExprArray), AST.arrayToNative(arrayExprArray)));
    }

    public Expr mkTermArray(ArrayExpr arrayExpr) {
        this.checkContextMatch(arrayExpr);
        return Expr.create(this, Native.mkArrayDefault(this.nCtx(), arrayExpr.getNativeObject()));
    }

    public SetSort mkSetSort(Sort sort) {
        this.checkContextMatch(sort);
        return new SetSort(this, sort);
    }

    public ArrayExpr mkEmptySet(Sort sort) {
        this.checkContextMatch(sort);
        return (ArrayExpr)Expr.create(this, Native.mkEmptySet(this.nCtx(), sort.getNativeObject()));
    }

    public ArrayExpr mkFullSet(Sort sort) {
        this.checkContextMatch(sort);
        return (ArrayExpr)Expr.create(this, Native.mkFullSet(this.nCtx(), sort.getNativeObject()));
    }

    public ArrayExpr mkSetAdd(ArrayExpr arrayExpr, Expr expr) {
        this.checkContextMatch(arrayExpr);
        this.checkContextMatch(expr);
        return (ArrayExpr)Expr.create(this, Native.mkSetAdd(this.nCtx(), arrayExpr.getNativeObject(), expr.getNativeObject()));
    }

    public ArrayExpr mkSetDel(ArrayExpr arrayExpr, Expr expr) {
        this.checkContextMatch(arrayExpr);
        this.checkContextMatch(expr);
        return (ArrayExpr)Expr.create(this, Native.mkSetDel(this.nCtx(), arrayExpr.getNativeObject(), expr.getNativeObject()));
    }

    public ArrayExpr mkSetUnion(ArrayExpr ... arrayExprArray) {
        this.checkContextMatch(arrayExprArray);
        return (ArrayExpr)Expr.create(this, Native.mkSetUnion(this.nCtx(), arrayExprArray.length, AST.arrayToNative(arrayExprArray)));
    }

    public ArrayExpr mkSetIntersection(ArrayExpr ... arrayExprArray) {
        this.checkContextMatch(arrayExprArray);
        return (ArrayExpr)Expr.create(this, Native.mkSetIntersect(this.nCtx(), arrayExprArray.length, AST.arrayToNative(arrayExprArray)));
    }

    public ArrayExpr mkSetDifference(ArrayExpr arrayExpr, ArrayExpr arrayExpr2) {
        this.checkContextMatch(arrayExpr);
        this.checkContextMatch(arrayExpr2);
        return (ArrayExpr)Expr.create(this, Native.mkSetDifference(this.nCtx(), arrayExpr.getNativeObject(), arrayExpr2.getNativeObject()));
    }

    public ArrayExpr mkSetComplement(ArrayExpr arrayExpr) {
        this.checkContextMatch(arrayExpr);
        return (ArrayExpr)Expr.create(this, Native.mkSetComplement(this.nCtx(), arrayExpr.getNativeObject()));
    }

    public BoolExpr mkSetMembership(Expr expr, ArrayExpr arrayExpr) {
        this.checkContextMatch(expr);
        this.checkContextMatch(arrayExpr);
        return (BoolExpr)Expr.create(this, Native.mkSetMember(this.nCtx(), expr.getNativeObject(), arrayExpr.getNativeObject()));
    }

    public BoolExpr mkSetSubset(ArrayExpr arrayExpr, ArrayExpr arrayExpr2) {
        this.checkContextMatch(arrayExpr);
        this.checkContextMatch(arrayExpr2);
        return (BoolExpr)Expr.create(this, Native.mkSetSubset(this.nCtx(), arrayExpr.getNativeObject(), arrayExpr2.getNativeObject()));
    }

    public Expr mkNumeral(String string, Sort sort) {
        this.checkContextMatch(sort);
        return Expr.create(this, Native.mkNumeral(this.nCtx(), string, sort.getNativeObject()));
    }

    public Expr mkNumeral(int n, Sort sort) {
        this.checkContextMatch(sort);
        return Expr.create(this, Native.mkInt(this.nCtx(), n, sort.getNativeObject()));
    }

    public Expr mkNumeral(long l, Sort sort) {
        this.checkContextMatch(sort);
        return Expr.create(this, Native.mkInt64(this.nCtx(), l, sort.getNativeObject()));
    }

    public RatNum mkReal(int n, int n2) {
        if (n2 == 0) {
            throw new Z3Exception("Denominator is zero");
        }
        return new RatNum(this, Native.mkReal(this.nCtx(), n, n2));
    }

    public RatNum mkReal(String string) {
        return new RatNum(this, Native.mkNumeral(this.nCtx(), string, this.getRealSort().getNativeObject()));
    }

    public RatNum mkReal(int n) {
        return new RatNum(this, Native.mkInt(this.nCtx(), n, this.getRealSort().getNativeObject()));
    }

    public RatNum mkReal(long l) {
        return new RatNum(this, Native.mkInt64(this.nCtx(), l, this.getRealSort().getNativeObject()));
    }

    public IntNum mkInt(String string) {
        return new IntNum(this, Native.mkNumeral(this.nCtx(), string, this.getIntSort().getNativeObject()));
    }

    public IntNum mkInt(int n) {
        return new IntNum(this, Native.mkInt(this.nCtx(), n, this.getIntSort().getNativeObject()));
    }

    public IntNum mkInt(long l) {
        return new IntNum(this, Native.mkInt64(this.nCtx(), l, this.getIntSort().getNativeObject()));
    }

    public BitVecNum mkBV(String string, int n) {
        return (BitVecNum)this.mkNumeral(string, (Sort)this.mkBitVecSort(n));
    }

    public BitVecNum mkBV(int n, int n2) {
        return (BitVecNum)this.mkNumeral(n, (Sort)this.mkBitVecSort(n2));
    }

    public BitVecNum mkBV(long l, int n) {
        return (BitVecNum)this.mkNumeral(l, (Sort)this.mkBitVecSort(n));
    }

    public Quantifier mkForall(Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) {
        return new Quantifier(this, true, sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier mkForall(Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) {
        return new Quantifier(this, true, exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public Quantifier mkExists(Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) {
        return new Quantifier(this, false, sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier mkExists(Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) {
        return new Quantifier(this, false, exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public Quantifier mkQuantifier(boolean bl, Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) {
        if (bl) {
            return this.mkForall(sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
        }
        return this.mkExists(sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier mkQuantifier(boolean bl, Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) {
        if (bl) {
            return this.mkForall(exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
        }
        return this.mkExists(exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public void setPrintMode(Z3_ast_print_mode z3_ast_print_mode) {
        Native.setAstPrintMode(this.nCtx(), z3_ast_print_mode.toInt());
    }

    public String benchmarkToSMTString(String string, String string2, String string3, String string4, BoolExpr[] boolExprArray, BoolExpr boolExpr) {
        return Native.benchmarkToSmtlibString(this.nCtx(), string, string2, string3, string4, boolExprArray.length, AST.arrayToNative(boolExprArray), boolExpr.getNativeObject());
    }

    public void parseSMTLIBString(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) {
        int n = Symbol.arrayLength(symbolArray);
        int n2 = Sort.arrayLength(sortArray);
        int n3 = Symbol.arrayLength(symbolArray2);
        int n4 = AST.arrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        Native.parseSmtlibString(this.nCtx(), string, AST.arrayLength(sortArray), Symbol.arrayToNative(symbolArray), AST.arrayToNative(sortArray), AST.arrayLength(funcDeclArray), Symbol.arrayToNative(symbolArray2), AST.arrayToNative(funcDeclArray));
    }

    public void parseSMTLIBFile(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) {
        int n = Symbol.arrayLength(symbolArray);
        int n2 = Sort.arrayLength(sortArray);
        int n3 = Symbol.arrayLength(symbolArray2);
        int n4 = AST.arrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        Native.parseSmtlibFile(this.nCtx(), string, AST.arrayLength(sortArray), Symbol.arrayToNative(symbolArray), AST.arrayToNative(sortArray), AST.arrayLength(funcDeclArray), Symbol.arrayToNative(symbolArray2), AST.arrayToNative(funcDeclArray));
    }

    public int getNumSMTLIBFormulas() {
        return Native.getSmtlibNumFormulas(this.nCtx());
    }

    public BoolExpr[] getSMTLIBFormulas() {
        int n = this.getNumSMTLIBFormulas();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = (BoolExpr)Expr.create(this, Native.getSmtlibFormula(this.nCtx(), i));
        }
        return boolExprArray;
    }

    public int getNumSMTLIBAssumptions() {
        return Native.getSmtlibNumAssumptions(this.nCtx());
    }

    public BoolExpr[] getSMTLIBAssumptions() {
        int n = this.getNumSMTLIBAssumptions();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = (BoolExpr)Expr.create(this, Native.getSmtlibAssumption(this.nCtx(), i));
        }
        return boolExprArray;
    }

    public int getNumSMTLIBDecls() {
        return Native.getSmtlibNumDecls(this.nCtx());
    }

    public FuncDecl[] getSMTLIBDecls() {
        int n = this.getNumSMTLIBDecls();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this, Native.getSmtlibDecl(this.nCtx(), i));
        }
        return funcDeclArray;
    }

    public int getNumSMTLIBSorts() {
        return Native.getSmtlibNumSorts(this.nCtx());
    }

    public Sort[] getSMTLIBSorts() {
        int n = this.getNumSMTLIBSorts();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.create(this, Native.getSmtlibSort(this.nCtx(), i));
        }
        return sortArray;
    }

    public BoolExpr parseSMTLIB2String(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) {
        int n = Symbol.arrayLength(symbolArray);
        int n2 = Sort.arrayLength(sortArray);
        int n3 = Symbol.arrayLength(symbolArray2);
        int n4 = AST.arrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        return (BoolExpr)Expr.create(this, Native.parseSmtlib2String(this.nCtx(), string, AST.arrayLength(sortArray), Symbol.arrayToNative(symbolArray), AST.arrayToNative(sortArray), AST.arrayLength(funcDeclArray), Symbol.arrayToNative(symbolArray2), AST.arrayToNative(funcDeclArray)));
    }

    public BoolExpr parseSMTLIB2File(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) {
        int n = Symbol.arrayLength(symbolArray);
        int n2 = Sort.arrayLength(sortArray);
        int n3 = Symbol.arrayLength(symbolArray2);
        int n4 = AST.arrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        return (BoolExpr)Expr.create(this, Native.parseSmtlib2File(this.nCtx(), string, AST.arrayLength(sortArray), Symbol.arrayToNative(symbolArray), AST.arrayToNative(sortArray), AST.arrayLength(funcDeclArray), Symbol.arrayToNative(symbolArray2), AST.arrayToNative(funcDeclArray)));
    }

    public Goal mkGoal(boolean bl, boolean bl2, boolean bl3) {
        return new Goal(this, bl, bl2, bl3);
    }

    public Params mkParams() {
        return new Params(this);
    }

    public int getNumTactics() {
        return Native.getNumTactics(this.nCtx());
    }

    public String[] getTacticNames() {
        int n = this.getNumTactics();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getTacticName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String getTacticDescription(String string) {
        return Native.tacticGetDescr(this.nCtx(), string);
    }

    public Tactic mkTactic(String string) {
        return new Tactic(this, string);
    }

    public Tactic andThen(Tactic tactic, Tactic tactic2, Tactic ... tacticArray) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        this.checkContextMatch(tacticArray);
        long l = 0L;
        if (tacticArray != null && tacticArray.length > 0) {
            l = tacticArray[tacticArray.length - 1].getNativeObject();
            for (int i = tacticArray.length - 2; i >= 0; --i) {
                l = Native.tacticAndThen(this.nCtx(), tacticArray[i].getNativeObject(), l);
            }
        }
        if (l != 0L) {
            l = Native.tacticAndThen(this.nCtx(), tactic2.getNativeObject(), l);
            return new Tactic(this, Native.tacticAndThen(this.nCtx(), tactic.getNativeObject(), l));
        }
        return new Tactic(this, Native.tacticAndThen(this.nCtx(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public Tactic then(Tactic tactic, Tactic tactic2, Tactic ... tacticArray) {
        return this.andThen(tactic, tactic2, tacticArray);
    }

    public Tactic orElse(Tactic tactic, Tactic tactic2) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        return new Tactic(this, Native.tacticOrElse(this.nCtx(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public Tactic tryFor(Tactic tactic, int n) {
        this.checkContextMatch(tactic);
        return new Tactic(this, Native.tacticTryFor(this.nCtx(), tactic.getNativeObject(), n));
    }

    public Tactic when(Probe probe, Tactic tactic) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(probe);
        return new Tactic(this, Native.tacticWhen(this.nCtx(), probe.getNativeObject(), tactic.getNativeObject()));
    }

    public Tactic cond(Probe probe, Tactic tactic, Tactic tactic2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        return new Tactic(this, Native.tacticCond(this.nCtx(), probe.getNativeObject(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public Tactic repeat(Tactic tactic, int n) {
        this.checkContextMatch(tactic);
        return new Tactic(this, Native.tacticRepeat(this.nCtx(), tactic.getNativeObject(), n));
    }

    public Tactic skip() {
        return new Tactic(this, Native.tacticSkip(this.nCtx()));
    }

    public Tactic fail() {
        return new Tactic(this, Native.tacticFail(this.nCtx()));
    }

    public Tactic failIf(Probe probe) {
        this.checkContextMatch(probe);
        return new Tactic(this, Native.tacticFailIf(this.nCtx(), probe.getNativeObject()));
    }

    public Tactic failIfNotDecided() {
        return new Tactic(this, Native.tacticFailIfNotDecided(this.nCtx()));
    }

    public Tactic usingParams(Tactic tactic, Params params) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(params);
        return new Tactic(this, Native.tacticUsingParams(this.nCtx(), tactic.getNativeObject(), params.getNativeObject()));
    }

    public Tactic with(Tactic tactic, Params params) {
        return this.usingParams(tactic, params);
    }

    public Tactic parOr(Tactic ... tacticArray) {
        this.checkContextMatch(tacticArray);
        return new Tactic(this, Native.tacticParOr(this.nCtx(), Tactic.arrayLength(tacticArray), Tactic.arrayToNative(tacticArray)));
    }

    public Tactic parAndThen(Tactic tactic, Tactic tactic2) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        return new Tactic(this, Native.tacticParAndThen(this.nCtx(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public void interrupt() {
        Native.interrupt(this.nCtx());
    }

    public int getNumProbes() {
        return Native.getNumProbes(this.nCtx());
    }

    public String[] getProbeNames() {
        int n = this.getNumProbes();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getProbeName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String getProbeDescription(String string) {
        return Native.probeGetDescr(this.nCtx(), string);
    }

    public Probe mkProbe(String string) {
        return new Probe(this, string);
    }

    public Probe constProbe(double d) {
        return new Probe(this, Native.probeConst(this.nCtx(), d));
    }

    public Probe lt(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeLt(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe gt(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeGt(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe le(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeLe(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe ge(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeGe(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe eq(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeEq(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe and(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeAnd(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe or(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeOr(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe not(Probe probe) {
        this.checkContextMatch(probe);
        return new Probe(this, Native.probeNot(this.nCtx(), probe.getNativeObject()));
    }

    public Solver mkSolver() {
        return this.mkSolver((Symbol)null);
    }

    public Solver mkSolver(Symbol symbol) {
        if (symbol == null) {
            return new Solver(this, Native.mkSolver(this.nCtx()));
        }
        return new Solver(this, Native.mkSolverForLogic(this.nCtx(), symbol.getNativeObject()));
    }

    public Solver mkSolver(String string) {
        return this.mkSolver(this.mkSymbol(string));
    }

    public Solver mkSimpleSolver() {
        return new Solver(this, Native.mkSimpleSolver(this.nCtx()));
    }

    public Solver mkSolver(Tactic tactic) {
        return new Solver(this, Native.mkSolverFromTactic(this.nCtx(), tactic.getNativeObject()));
    }

    public Fixedpoint mkFixedpoint() {
        return new Fixedpoint(this);
    }

    public Optimize mkOptimize() {
        return new Optimize(this);
    }

    public FPRMSort mkFPRoundingModeSort() {
        return new FPRMSort(this);
    }

    public FPRMExpr mkFPRoundNearestTiesToEven() {
        return new FPRMExpr(this, Native.mkFpaRoundNearestTiesToEven(this.nCtx()));
    }

    public FPRMNum mkFPRNE() {
        return new FPRMNum(this, Native.mkFpaRne(this.nCtx()));
    }

    public FPRMNum mkFPRoundNearestTiesToAway() {
        return new FPRMNum(this, Native.mkFpaRoundNearestTiesToAway(this.nCtx()));
    }

    public FPRMNum mkFPRNA() {
        return new FPRMNum(this, Native.mkFpaRna(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardPositive() {
        return new FPRMNum(this, Native.mkFpaRoundTowardPositive(this.nCtx()));
    }

    public FPRMNum mkFPRTP() {
        return new FPRMNum(this, Native.mkFpaRtp(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardNegative() {
        return new FPRMNum(this, Native.mkFpaRoundTowardNegative(this.nCtx()));
    }

    public FPRMNum mkFPRTN() {
        return new FPRMNum(this, Native.mkFpaRtn(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardZero() {
        return new FPRMNum(this, Native.mkFpaRoundTowardZero(this.nCtx()));
    }

    public FPRMNum mkFPRTZ() {
        return new FPRMNum(this, Native.mkFpaRtz(this.nCtx()));
    }

    public FPSort mkFPSort(int n, int n2) {
        return new FPSort(this, n, n2);
    }

    public FPSort mkFPSortHalf() {
        return new FPSort(this, Native.mkFpaSortHalf(this.nCtx()));
    }

    public FPSort mkFPSort16() {
        return new FPSort(this, Native.mkFpaSort16(this.nCtx()));
    }

    public FPSort mkFPSortSingle() {
        return new FPSort(this, Native.mkFpaSortSingle(this.nCtx()));
    }

    public FPSort mkFPSort32() {
        return new FPSort(this, Native.mkFpaSort32(this.nCtx()));
    }

    public FPSort mkFPSortDouble() {
        return new FPSort(this, Native.mkFpaSortDouble(this.nCtx()));
    }

    public FPSort mkFPSort64() {
        return new FPSort(this, Native.mkFpaSort64(this.nCtx()));
    }

    public FPSort mkFPSortQuadruple() {
        return new FPSort(this, Native.mkFpaSortQuadruple(this.nCtx()));
    }

    public FPSort mkFPSort128() {
        return new FPSort(this, Native.mkFpaSort128(this.nCtx()));
    }

    public FPNum mkFPNaN(FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNan(this.nCtx(), fPSort.getNativeObject()));
    }

    public FPNum mkFPInf(FPSort fPSort, boolean bl) {
        return new FPNum(this, Native.mkFpaInf(this.nCtx(), fPSort.getNativeObject(), bl));
    }

    public FPNum mkFPZero(FPSort fPSort, boolean bl) {
        return new FPNum(this, Native.mkFpaZero(this.nCtx(), fPSort.getNativeObject(), bl));
    }

    public FPNum mkFPNumeral(float f, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralFloat(this.nCtx(), f, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(double d, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralDouble(this.nCtx(), d, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(int n, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralInt(this.nCtx(), n, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(boolean bl, int n, int n2, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralIntUint(this.nCtx(), bl, n, n2, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(boolean bl, long l, long l2, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralInt64Uint64(this.nCtx(), bl, l, l2, fPSort.getNativeObject()));
    }

    public FPNum mkFP(float f, FPSort fPSort) {
        return this.mkFPNumeral(f, fPSort);
    }

    public FPNum mkFP(double d, FPSort fPSort) {
        return this.mkFPNumeral(d, fPSort);
    }

    public FPNum mkFP(int n, FPSort fPSort) {
        return this.mkFPNumeral(n, fPSort);
    }

    public FPNum mkFP(boolean bl, int n, int n2, FPSort fPSort) {
        return this.mkFPNumeral(bl, n2, n, fPSort);
    }

    public FPNum mkFP(boolean bl, long l, long l2, FPSort fPSort) {
        return this.mkFPNumeral(bl, l2, l, fPSort);
    }

    public FPExpr mkFPAbs(FPExpr fPExpr) {
        return new FPExpr(this, Native.mkFpaAbs(this.nCtx(), fPExpr.getNativeObject()));
    }

    public FPExpr mkFPNeg(FPExpr fPExpr) {
        return new FPExpr(this, Native.mkFpaNeg(this.nCtx(), fPExpr.getNativeObject()));
    }

    public FPExpr mkFPAdd(FPRMExpr fPRMExpr, FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaAdd(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public FPExpr mkFPSub(FPRMExpr fPRMExpr, FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaSub(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public FPExpr mkFPMul(FPRMExpr fPRMExpr, FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaMul(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public FPExpr mkFPDiv(FPRMExpr fPRMExpr, FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaDiv(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public FPExpr mkFPFMA(FPRMExpr fPRMExpr, FPExpr fPExpr, FPExpr fPExpr2, FPExpr fPExpr3) {
        return new FPExpr(this, Native.mkFpaFma(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), fPExpr2.getNativeObject(), fPExpr3.getNativeObject()));
    }

    public FPExpr mkFPSqrt(FPRMExpr fPRMExpr, FPExpr fPExpr) {
        return new FPExpr(this, Native.mkFpaSqrt(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject()));
    }

    public FPExpr mkFPRem(FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaRem(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public FPExpr mkFPRoundToIntegral(FPRMExpr fPRMExpr, FPExpr fPExpr) {
        return new FPExpr(this, Native.mkFpaRoundToIntegral(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject()));
    }

    public FPExpr mkFPMin(FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaMin(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public FPExpr mkFPMax(FPExpr fPExpr, FPExpr fPExpr2) {
        return new FPExpr(this, Native.mkFpaMax(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public BoolExpr mkFPLEq(FPExpr fPExpr, FPExpr fPExpr2) {
        return new BoolExpr(this, Native.mkFpaLeq(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public BoolExpr mkFPLt(FPExpr fPExpr, FPExpr fPExpr2) {
        return new BoolExpr(this, Native.mkFpaLt(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public BoolExpr mkFPGEq(FPExpr fPExpr, FPExpr fPExpr2) {
        return new BoolExpr(this, Native.mkFpaGeq(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public BoolExpr mkFPGt(FPExpr fPExpr, FPExpr fPExpr2) {
        return new BoolExpr(this, Native.mkFpaGt(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public BoolExpr mkFPEq(FPExpr fPExpr, FPExpr fPExpr2) {
        return new BoolExpr(this, Native.mkFpaEq(this.nCtx(), fPExpr.getNativeObject(), fPExpr2.getNativeObject()));
    }

    public BoolExpr mkFPIsNormal(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsNormal(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BoolExpr mkFPIsSubnormal(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsSubnormal(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BoolExpr mkFPIsZero(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsZero(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BoolExpr mkFPIsInfinite(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsInfinite(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BoolExpr mkFPIsNaN(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsNan(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BoolExpr mkFPIsNegative(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsNegative(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BoolExpr mkFPIsPositive(FPExpr fPExpr) {
        return new BoolExpr(this, Native.mkFpaIsPositive(this.nCtx(), fPExpr.getNativeObject()));
    }

    public FPExpr mkFP(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, BitVecExpr bitVecExpr3) {
        return new FPExpr(this, Native.mkFpaFp(this.nCtx(), bitVecExpr.getNativeObject(), bitVecExpr2.getNativeObject(), bitVecExpr3.getNativeObject()));
    }

    public FPExpr mkFPToFP(BitVecExpr bitVecExpr, FPSort fPSort) {
        return new FPExpr(this, Native.mkFpaToFpBv(this.nCtx(), bitVecExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(FPRMExpr fPRMExpr, FPExpr fPExpr, FPSort fPSort) {
        return new FPExpr(this, Native.mkFpaToFpFloat(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(FPRMExpr fPRMExpr, RealExpr realExpr, FPSort fPSort) {
        return new FPExpr(this, Native.mkFpaToFpReal(this.nCtx(), fPRMExpr.getNativeObject(), realExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(FPRMExpr fPRMExpr, BitVecExpr bitVecExpr, FPSort fPSort, boolean bl) {
        if (bl) {
            return new FPExpr(this, Native.mkFpaToFpSigned(this.nCtx(), fPRMExpr.getNativeObject(), bitVecExpr.getNativeObject(), fPSort.getNativeObject()));
        }
        return new FPExpr(this, Native.mkFpaToFpUnsigned(this.nCtx(), fPRMExpr.getNativeObject(), bitVecExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(FPSort fPSort, FPRMExpr fPRMExpr, FPExpr fPExpr) {
        return new FPExpr(this, Native.mkFpaToFpFloat(this.nCtx(), fPSort.getNativeObject(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject()));
    }

    public BitVecExpr mkFPToBV(FPRMExpr fPRMExpr, FPExpr fPExpr, int n, boolean bl) {
        if (bl) {
            return new BitVecExpr(this, Native.mkFpaToSbv(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), n));
        }
        return new BitVecExpr(this, Native.mkFpaToUbv(this.nCtx(), fPRMExpr.getNativeObject(), fPExpr.getNativeObject(), n));
    }

    public RealExpr mkFPToReal(FPExpr fPExpr) {
        return new RealExpr(this, Native.mkFpaToReal(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BitVecExpr mkFPToIEEEBV(FPExpr fPExpr) {
        return new BitVecExpr(this, Native.mkFpaToIeeeBv(this.nCtx(), fPExpr.getNativeObject()));
    }

    public BitVecExpr mkFPToFP(FPRMExpr fPRMExpr, IntExpr intExpr, RealExpr realExpr, FPSort fPSort) {
        return new BitVecExpr(this, Native.mkFpaToFpIntReal(this.nCtx(), fPRMExpr.getNativeObject(), intExpr.getNativeObject(), realExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public AST wrapAST(long l) {
        return AST.create(this, l);
    }

    public long unwrapAST(AST aST) {
        return aST.getNativeObject();
    }

    public String SimplifyHelp() {
        return Native.simplifyGetHelp(this.nCtx());
    }

    public ParamDescrs getSimplifyParameterDescriptions() {
        return new ParamDescrs(this, Native.simplifyGetParamDescrs(this.nCtx()));
    }

    public void updateParamValue(String string, String string2) {
        Native.updateParamValue(this.nCtx(), string, string2);
    }

    long nCtx() {
        return this.m_ctx;
    }

    void initContext() {
        this.setPrintMode(Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT);
        Native.setInternalErrorHandler(this.nCtx());
    }

    void checkContextMatch(Z3Object z3Object) {
        if (this != z3Object.getContext()) {
            throw new Z3Exception("Context mismatch");
        }
    }

    void checkContextMatch(Z3Object[] z3ObjectArray) {
        if (z3ObjectArray != null) {
            for (Z3Object z3Object : z3ObjectArray) {
                this.checkContextMatch(z3Object);
            }
        }
    }

    public IDecRefQueue getASTDRQ() {
        return this.m_AST_DRQ;
    }

    public IDecRefQueue getASTMapDRQ() {
        return this.m_ASTMap_DRQ;
    }

    public IDecRefQueue getASTVectorDRQ() {
        return this.m_ASTVector_DRQ;
    }

    public IDecRefQueue getApplyResultDRQ() {
        return this.m_ApplyResult_DRQ;
    }

    public IDecRefQueue getFuncEntryDRQ() {
        return this.m_FuncEntry_DRQ;
    }

    public IDecRefQueue getFuncInterpDRQ() {
        return this.m_FuncInterp_DRQ;
    }

    public IDecRefQueue getGoalDRQ() {
        return this.m_Goal_DRQ;
    }

    public IDecRefQueue getModelDRQ() {
        return this.m_Model_DRQ;
    }

    public IDecRefQueue getParamsDRQ() {
        return this.m_Params_DRQ;
    }

    public IDecRefQueue getParamDescrsDRQ() {
        return this.m_ParamDescrs_DRQ;
    }

    public IDecRefQueue getProbeDRQ() {
        return this.m_Probe_DRQ;
    }

    public IDecRefQueue getSolverDRQ() {
        return this.m_Solver_DRQ;
    }

    public IDecRefQueue getStatisticsDRQ() {
        return this.m_Statistics_DRQ;
    }

    public IDecRefQueue getTacticDRQ() {
        return this.m_Tactic_DRQ;
    }

    public IDecRefQueue getFixedpointDRQ() {
        return this.m_Fixedpoint_DRQ;
    }

    public IDecRefQueue getOptimizeDRQ() {
        return this.m_Optimize_DRQ;
    }

    protected void finalize() {
        this.dispose();
        if (this.m_refCount == 0L) {
            try {
                Native.delContext(this.m_ctx);
            }
            catch (Z3Exception z3Exception) {
                // empty catch block
            }
            this.m_ctx = 0L;
        }
    }

    @Override
    public void dispose() {
        this.m_AST_DRQ.clear(this);
        this.m_ASTMap_DRQ.clear(this);
        this.m_ASTVector_DRQ.clear(this);
        this.m_ApplyResult_DRQ.clear(this);
        this.m_FuncEntry_DRQ.clear(this);
        this.m_FuncInterp_DRQ.clear(this);
        this.m_Goal_DRQ.clear(this);
        this.m_Model_DRQ.clear(this);
        this.m_Params_DRQ.clear(this);
        this.m_Probe_DRQ.clear(this);
        this.m_Solver_DRQ.clear(this);
        this.m_Statistics_DRQ.clear(this);
        this.m_Tactic_DRQ.clear(this);
        this.m_Fixedpoint_DRQ.clear(this);
        this.m_boolSort = null;
        this.m_intSort = null;
        this.m_realSort = null;
    }
}

