/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    @Override
    public String historicalName() {
        return "UTF8";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    private static final class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private Surrogate.Parser sgp;
        private byte repl = (byte)63;

        private Encoder(Charset charset) {
            super(charset, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return !Character.isSurrogate(c);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n, ByteBuffer byteBuffer, int n2) {
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n2);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n) {
            charBuffer.position(n);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            int n5 = n3 + Math.min(n2 - n, n4 - n3);
            while (n3 < n5 && cArray[n] < '\u0080') {
                byArray[n3++] = (byte)cArray[n++];
            }
            while (n < n2) {
                char c = cArray[n];
                if (c < '\u0080') {
                    if (n3 >= n4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)c;
                } else if (c < '\u0800') {
                    if (n4 - n3 < 2) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xC0 | c >> 6);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                } else if (Character.isSurrogate(c)) {
                    int n6;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n6 = this.sgp.parse(c, cArray, n, n2)) < 0) {
                        UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
                        return this.sgp.error();
                    }
                    if (n4 - n3 < 4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n3++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n6 & 0x3F);
                    ++n;
                } else {
                    if (n4 - n3 < 3) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xE0 | c >> 12);
                    byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                }
                ++n;
            }
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)c);
                } else if (c < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xC0 | c >> 6));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate(c)) {
                    int n2;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n2 = this.sgp.parse(c, charBuffer)) < 0) {
                        charBuffer.position(n);
                        return this.sgp.error();
                    }
                    if (byteBuffer.remaining() < 4) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xF0 | n2 >> 18));
                    byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 & 0x3F));
                    ++n;
                } else {
                    if (byteBuffer.remaining() < 3) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xE0 | c >> 12));
                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                }
                ++n;
            }
            charBuffer.position(n);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = n + n2;
            int n4 = 0;
            int n5 = n4 + Math.min(n2, byArray.length);
            while (n4 < n5 && cArray[n] < '\u0080') {
                byArray[n4++] = (byte)cArray[n++];
            }
            while (n < n3) {
                char c;
                if ((c = cArray[n++]) < '\u0080') {
                    byArray[n4++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    byArray[n4++] = (byte)(0xC0 | c >> 6);
                    byArray[n4++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    int n6;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n6 = this.sgp.parse(c, cArray, n - 1, n3)) < 0) {
                        if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                            return -1;
                        }
                        byArray[n4++] = this.repl;
                        continue;
                    }
                    byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                    ++n;
                    continue;
                }
                byArray[n4++] = (byte)(0xE0 | c >> 12);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            return n4;
        }
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int n) {
            return (n & 0xC0) != 128;
        }

        private static boolean isMalformed3(int n, int n2, int n3) {
            return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static boolean isMalformed3_2(int n, int n2) {
            return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed4(int n, int n2, int n3) {
            return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static boolean isMalformed4_2(int n, int n2) {
            return n == 240 && n2 == 144 || (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed4_3(int n) {
            return (n & 0xC0) != 128;
        }

        private static CoderResult lookupN(ByteBuffer byteBuffer, int n) {
            for (int i = 1; i < n; ++i) {
                if (!Decoder.isNotContinuation(byteBuffer.get())) continue;
                return CoderResult.malformedForLength(i);
            }
            return CoderResult.malformedForLength(n);
        }

        private static CoderResult malformedN(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || Decoder.isNotContinuation(by2) ? 1 : 2);
                }
                case 4: {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || Decoder.isNotContinuation(n3)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(byteBuffer.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n3);
            UTF_8.updatePositions(byteBuffer, n, charBuffer, n2);
            return coderResult;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.position(n);
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n2);
            byteBuffer.position(n);
            return coderResult;
        }

        private static CoderResult malformedForLength(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
            UTF_8.updatePositions(byteBuffer, n, charBuffer, n2);
            return CoderResult.malformedForLength(n3);
        }

        private static CoderResult malformedForLength(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.position(n);
            return CoderResult.malformedForLength(n2);
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
            UTF_8.updatePositions(buffer, n, buffer2, n3);
            return n4 == 0 || n2 - n < n4 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2) {
            buffer.position(n);
            return n2 == 0 || buffer.remaining() < n2 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            int n5 = n3 + Math.min(n2 - n, n4 - n3);
            while (n3 < n5 && byArray[n] >= 0) {
                cArray[n3++] = (char)byArray[n++];
            }
            while (n < n2) {
                char c;
                byte by;
                byte by2;
                int n6;
                byte by3 = byArray[n];
                if (by3 >= 0) {
                    if (n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 1);
                    }
                    cArray[n3++] = (char)by3;
                    ++n;
                    continue;
                }
                if (by3 >> 5 == -2 && (by3 & 0x1E) != 0) {
                    if (n2 - n < 2 || n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 2);
                    }
                    n6 = byArray[n + 1];
                    if (Decoder.isNotContinuation(n6)) {
                        return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 1);
                    }
                    cArray[n3++] = (char)(by3 << 6 ^ n6 ^ 0xF80);
                    n += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    n6 = n2 - n;
                    if (n6 < 3 || n3 >= n4) {
                        if (n6 > 1 && Decoder.isMalformed3_2(by3, byArray[n + 1])) {
                            return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 1);
                        }
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 3);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    if (Decoder.isMalformed3(by3, by2, by)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 3);
                    }
                    c = (char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 3);
                    }
                    cArray[n3++] = c;
                    n += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    n6 = n2 - n;
                    if (n6 < 4 || n4 - n3 < 2) {
                        if (n6 > 1 && Decoder.isMalformed4_2(by3, byArray[n + 1])) {
                            return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 1);
                        }
                        if (n6 > 2 && Decoder.isMalformed4_3(byArray[n + 2])) {
                            return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 2);
                        }
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 4);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    c = byArray[n + 3];
                    int n7 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                    if (Decoder.isMalformed4(by2, by, c) || !Character.isSupplementaryCodePoint(n7)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 4);
                    }
                    cArray[n3++] = Character.highSurrogate(n7);
                    cArray[n3++] = Character.lowSurrogate(n7);
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, charBuffer, n3, 1);
            }
            return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = byteBuffer.limit();
            while (n < n2) {
                char c;
                byte by;
                byte by2;
                int n3;
                byte by3 = byteBuffer.get();
                if (by3 >= 0) {
                    if (charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 1);
                    }
                    charBuffer.put((char)by3);
                    ++n;
                    continue;
                }
                if (by3 >> 5 == -2 && (by3 & 0x1E) != 0) {
                    if (n2 - n < 2 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 2);
                    }
                    n3 = byteBuffer.get();
                    if (Decoder.isNotContinuation(n3)) {
                        return Decoder.malformedForLength(byteBuffer, n, 1);
                    }
                    charBuffer.put((char)(by3 << 6 ^ n3 ^ 0xF80));
                    n += 2;
                    continue;
                }
                if (by3 >> 4 == -2) {
                    n3 = n2 - n;
                    if (n3 < 3 || charBuffer.remaining() < 1) {
                        if (n3 > 1 && Decoder.isMalformed3_2(by3, byteBuffer.get())) {
                            return Decoder.malformedForLength(byteBuffer, n, 1);
                        }
                        return Decoder.xflow(byteBuffer, n, 3);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed3(by3, by2, by = byteBuffer.get())) {
                        return Decoder.malformed(byteBuffer, n, 3);
                    }
                    c = (char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return Decoder.malformedForLength(byteBuffer, n, 3);
                    }
                    charBuffer.put(c);
                    n += 3;
                    continue;
                }
                if (by3 >> 3 == -2) {
                    n3 = n2 - n;
                    if (n3 < 4 || charBuffer.remaining() < 2) {
                        if (n3 > 1 && Decoder.isMalformed4_2(by3, byteBuffer.get())) {
                            return Decoder.malformedForLength(byteBuffer, n, 1);
                        }
                        if (n3 > 2 && Decoder.isMalformed4_3(byteBuffer.get())) {
                            return Decoder.malformedForLength(byteBuffer, n, 2);
                        }
                        return Decoder.xflow(byteBuffer, n, 4);
                    }
                    by2 = byteBuffer.get();
                    by = byteBuffer.get();
                    c = byteBuffer.get();
                    int n4 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                    if (Decoder.isMalformed4(by2, by, c) || !Character.isSupplementaryCodePoint(n4)) {
                        return Decoder.malformed(byteBuffer, n, 4);
                    }
                    charBuffer.put(Character.highSurrogate(n4));
                    charBuffer.put(Character.lowSurrogate(n4));
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, 1);
            }
            return Decoder.xflow(byteBuffer, n, 0);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        private static ByteBuffer getByteBuffer(ByteBuffer byteBuffer, byte[] byArray, int n) {
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.wrap(byArray);
            }
            byteBuffer.position(n);
            return byteBuffer;
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            int n3 = n + n2;
            int n4 = 0;
            int n5 = Math.min(n2, cArray.length);
            ByteBuffer byteBuffer = null;
            while (n4 < n5 && byArray[n] >= 0) {
                cArray[n4++] = (char)byArray[n++];
            }
            while (n < n3) {
                char c;
                byte by;
                byte by2;
                byte by3;
                if ((by3 = byArray[n++]) >= 0) {
                    cArray[n4++] = (char)by3;
                    continue;
                }
                if (by3 >> 5 == -2 && (by3 & 0x1E) != 0) {
                    if (n < n3) {
                        if (Decoder.isNotContinuation(by2 = byArray[n++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            --n;
                            continue;
                        }
                        cArray[n4++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    cArray[n4++] = this.replacement().charAt(0);
                    return n4;
                }
                if (by3 >> 4 == -2) {
                    if (n + 1 < n3) {
                        if (Decoder.isMalformed3(by3, by2 = byArray[n++], by = byArray[n++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, n -= 3);
                            n += Decoder.malformedN(byteBuffer, 3).length();
                            continue;
                        }
                        c = (char)(by3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                        if (Character.isSurrogate(c)) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            continue;
                        }
                        cArray[n4++] = c;
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if (n < n3 && Decoder.isMalformed3_2(by3, byArray[n])) {
                        cArray[n4++] = this.replacement().charAt(0);
                        continue;
                    }
                    cArray[n4++] = this.replacement().charAt(0);
                    return n4;
                }
                if (by3 >> 3 == -2) {
                    if (n + 2 < n3) {
                        by2 = byArray[n++];
                        by = byArray[n++];
                        c = byArray[n++];
                        int n6 = by3 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                        if (Decoder.isMalformed4(by2, by, c) || !Character.isSupplementaryCodePoint(n6)) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, n -= 4);
                            n += Decoder.malformedN(byteBuffer, 4).length();
                            continue;
                        }
                        cArray[n4++] = Character.highSurrogate(n6);
                        cArray[n4++] = Character.lowSurrogate(n6);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if (n < n3 && Decoder.isMalformed4_2(by3, byArray[n])) {
                        cArray[n4++] = this.replacement().charAt(0);
                        continue;
                    }
                    if (++n < n3 && Decoder.isMalformed4_3(byArray[n])) {
                        cArray[n4++] = this.replacement().charAt(0);
                        continue;
                    }
                    cArray[n4++] = this.replacement().charAt(0);
                    return n4;
                }
                if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                    return -1;
                }
                cArray[n4++] = this.replacement().charAt(0);
            }
            return n4;
        }
    }
}

