/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicReferenceFieldUpdater<T, V> {
    @CallerSensitive
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> clazz, Class<W> clazz2, String string) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(clazz, clazz2, string, Reflection.getCallerClass());
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T t, V v) {
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), v)) {
        }
        return v2;
    }

    public final V getAndUpdate(T t, UnaryOperator<V> unaryOperator) {
        Object r;
        V v;
        while (!this.compareAndSet(t, v = this.get(t), r = unaryOperator.apply(v))) {
        }
        return v;
    }

    public final V updateAndGet(T t, UnaryOperator<V> unaryOperator) {
        Object r;
        V v;
        while (!this.compareAndSet(t, v = this.get(t), r = unaryOperator.apply(v))) {
        }
        return (V)r;
    }

    public final V getAndAccumulate(T t, V v, BinaryOperator<V> binaryOperator) {
        Object r;
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), r = binaryOperator.apply(v2, v))) {
        }
        return v2;
    }

    public final V accumulateAndGet(T t, V v, BinaryOperator<V> binaryOperator) {
        Object r;
        V v2;
        while (!this.compareAndSet(t, v2 = this.get(t), r = binaryOperator.apply(v2, v))) {
        }
        return (V)r;
    }

    private static final class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<V> vclass;
        private final Class<?> cclass;

        AtomicReferenceFieldUpdaterImpl(final Class<T> clazz, Class<V> clazz2, final String string, Class<?> clazz3) {
            Class<?> clazz4;
            int n;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return clazz.getDeclaredField(string);
                    }
                });
                n = field.getModifiers();
                ReflectUtil.ensureMemberAccess(clazz3, clazz, null, n);
                ClassLoader classLoader = clazz.getClassLoader();
                ClassLoader classLoader2 = clazz3.getClassLoader();
                if (!(classLoader2 == null || classLoader2 == classLoader || classLoader != null && AtomicReferenceFieldUpdaterImpl.isAncestor(classLoader, classLoader2))) {
                    ReflectUtil.checkPackageAccess(clazz);
                }
                clazz4 = field.getType();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException.getException());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (clazz2 != clazz4) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(n)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(n) && clazz3 != clazz ? clazz3 : null;
            this.tclass = clazz;
            this.vclass = clazz2 == Object.class ? null : clazz2;
            this.offset = unsafe.objectFieldOffset(field);
        }

        private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
            ClassLoader classLoader3 = classLoader;
            do {
                if (classLoader2 != (classLoader3 = classLoader3.getParent())) continue;
                return true;
            } while (classLoader3 != null);
            return false;
        }

        void targetCheck(T t) {
            if (!this.tclass.isInstance(t)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
        }

        void updateCheck(T t, V v) {
            if (!this.tclass.isInstance(t) || v != null && this.vclass != null && !this.vclass.isInstance(v)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(t);
            }
        }

        @Override
        public boolean compareAndSet(T t, V v, V v2) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v2 != null && this.vclass != null && this.vclass != v2.getClass()) {
                this.updateCheck(t, v2);
            }
            return unsafe.compareAndSwapObject(t, this.offset, v, v2);
        }

        @Override
        public boolean weakCompareAndSet(T t, V v, V v2) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v2 != null && this.vclass != null && this.vclass != v2.getClass()) {
                this.updateCheck(t, v2);
            }
            return unsafe.compareAndSwapObject(t, this.offset, v, v2);
        }

        @Override
        public void set(T t, V v) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v != null && this.vclass != null && this.vclass != v.getClass()) {
                this.updateCheck(t, v);
            }
            unsafe.putObjectVolatile(t, this.offset, v);
        }

        @Override
        public void lazySet(T t, V v) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v != null && this.vclass != null && this.vclass != v.getClass()) {
                this.updateCheck(t, v);
            }
            unsafe.putOrderedObject(t, this.offset, v);
        }

        @Override
        public V get(T t) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null) {
                this.targetCheck(t);
            }
            return (V)unsafe.getObjectVolatile(t, this.offset);
        }

        @Override
        public V getAndSet(T t, V v) {
            if (t == null || t.getClass() != this.tclass || this.cclass != null || v != null && this.vclass != null && this.vclass != v.getClass()) {
                this.updateCheck(t, v);
            }
            return (V)unsafe.getAndSetObject(t, this.offset, v);
        }

        private void ensureProtectedAccess(T t) {
            if (this.cclass.isInstance(t)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + t.getClass().getName()));
        }
    }
}

