/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Authenticator;
import sun.security.ssl.ByteBufferInputStream;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;

final class EngineInputRecord
extends InputRecord {
    private SSLEngineImpl engine;
    private static ByteBuffer tmpBB = ByteBuffer.allocate(0);
    private boolean internalData;

    EngineInputRecord(SSLEngineImpl sSLEngineImpl) {
        this.engine = sSLEngineImpl;
    }

    @Override
    byte contentType() {
        if (this.internalData) {
            return super.contentType();
        }
        return 23;
    }

    int bytesInCompletePacket(ByteBuffer byteBuffer) throws SSLException {
        if (byteBuffer.remaining() < 5) {
            return -1;
        }
        int n = byteBuffer.position();
        byte by = byteBuffer.get(n);
        int n2 = 0;
        if (this.formatVerified || by == 22 || by == 21) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(byteBuffer.get(n + 1), byteBuffer.get(n + 2));
            if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
                throw new SSLException("Unsupported record version " + protocolVersion);
            }
            this.formatVerified = true;
            n2 = ((byteBuffer.get(n + 3) & 0xFF) << 8) + (byteBuffer.get(n + 4) & 0xFF) + 5;
        } else {
            boolean bl;
            boolean bl2 = bl = (by & 0x80) != 0;
            if (bl && (byteBuffer.get(n + 2) == 1 || byteBuffer.get(n + 2) == 4)) {
                ProtocolVersion protocolVersion = ProtocolVersion.valueOf(byteBuffer.get(n + 3), byteBuffer.get(n + 4));
                if ((protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) && protocolVersion.v != ProtocolVersion.SSL20Hello.v) {
                    throw new SSLException("Unsupported record version " + protocolVersion);
                }
                int n3 = bl ? 127 : 63;
                n2 = ((by & n3) << 8) + (byteBuffer.get(n + 1) & 0xFF) + (bl ? 2 : 3);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return n2;
    }

    ByteBuffer decrypt(Authenticator authenticator, CipherBox cipherBox, ByteBuffer byteBuffer) throws BadPaddingException {
        if (this.internalData) {
            this.decrypt(authenticator, cipherBox);
            return tmpBB;
        }
        BadPaddingException badPaddingException = null;
        int n = authenticator instanceof MAC ? ((MAC)authenticator).MAClen() : 0;
        int n2 = byteBuffer.remaining();
        if (!cipherBox.isNullCipher()) {
            try {
                int n3 = cipherBox.applyExplicitNonce(authenticator, this.contentType(), byteBuffer);
                if (cipherBox.isAEADMode()) {
                    byteBuffer.position(byteBuffer.position() + n3);
                }
                cipherBox.decrypt(byteBuffer, n);
                byteBuffer.position(n3);
            }
            catch (BadPaddingException badPaddingException2) {
                badPaddingException = badPaddingException2;
            }
        }
        if (authenticator instanceof MAC && n != 0) {
            MAC mAC = (MAC)authenticator;
            int n4 = byteBuffer.limit() - n;
            if (byteBuffer.remaining() < n) {
                if (badPaddingException == null) {
                    badPaddingException = new BadPaddingException("bad record");
                }
                n4 = n2 - n;
                byteBuffer.limit(n2);
            }
            if (EngineInputRecord.checkMacTags(this.contentType(), byteBuffer, mAC, false) && badPaddingException == null) {
                badPaddingException = new BadPaddingException("bad record MAC");
            }
            if (cipherBox.isCBCMode()) {
                int n5 = EngineInputRecord.calculateRemainingLen(mAC, n2, n4);
                if (n5 > this.buf.length) {
                    throw new RuntimeException("Internal buffer capacity error");
                }
                EngineInputRecord.checkMacTags(this.contentType(), this.buf, 0, n5, mAC, true);
            }
            byteBuffer.limit(n4);
        }
        if (badPaddingException != null) {
            throw badPaddingException;
        }
        return byteBuffer.slice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMacTags(byte by, ByteBuffer byteBuffer, MAC mAC, boolean bl) {
        int n = byteBuffer.position();
        int n2 = mAC.MAClen();
        int n3 = byteBuffer.limit();
        int n4 = n3 - n2;
        byteBuffer.limit(n4);
        byte[] byArray = mAC.compute(by, byteBuffer, bl);
        if (byArray == null || n2 != byArray.length) {
            throw new RuntimeException("Internal MAC error");
        }
        byteBuffer.position(n4);
        byteBuffer.limit(n3);
        try {
            int[] nArray = EngineInputRecord.compareMacTags(byteBuffer, byArray);
            boolean bl2 = nArray[0] != 0;
            return bl2;
        }
        finally {
            byteBuffer.position(n);
            byteBuffer.limit(n4);
        }
    }

    private static int[] compareMacTags(ByteBuffer byteBuffer, byte[] byArray) {
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < byArray.length; ++i) {
            if (byteBuffer.get() != byArray[i]) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    @Override
    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(n2).put(byArray, 0, n2).flip();
        this.engine.writer.putOutboundDataSync(byteBuffer);
    }

    ByteBuffer read(ByteBuffer byteBuffer) throws IOException {
        Object object;
        if (!this.formatVerified || byteBuffer.get(byteBuffer.position()) != 23) {
            this.internalData = true;
            this.read(new ByteBufferInputStream(byteBuffer), null);
            return tmpBB;
        }
        this.internalData = false;
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        ProtocolVersion protocolVersion = ProtocolVersion.valueOf(byteBuffer.get(n + 1), byteBuffer.get(n + 2));
        if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + protocolVersion);
        }
        int n3 = this.bytesInCompletePacket(byteBuffer);
        assert (n3 > 0);
        if (debug != null && Debug.isOn("packet")) {
            try {
                object = new HexDumpEncoder();
                ByteBuffer byteBuffer2 = byteBuffer.duplicate();
                byteBuffer2.limit(n + n3);
                System.out.println("[Raw read (bb)]: length = " + n3);
                object.encodeBuffer(byteBuffer2, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byteBuffer.position(n + 5);
        byteBuffer.limit(n + n3);
        object = byteBuffer.slice();
        byteBuffer.position(byteBuffer.limit());
        byteBuffer.limit(n2);
        return object;
    }
}

