/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 1.0
import "content"

Rectangle {
   id: clock
    property string value0 : "0"
    property string value1 : "0"
    property string value2 : "0"
    property string value3 : "0"
    property string title : "Time"
    property string hours
    property string minutes
    property real shift
    property int seconds
 
   Properties { id:prop }
    
    function timeChanged() {
        var date = new Date;
        hours = shift ? date.getUTCHours() + Math.floor(clock.shift) : date.getHours()
      /*  night = ( hours < 7 || hours > 19 )*/
        minutes = shift ? date.getUTCMinutes() + ((clock.shift % 1) * 60) : date.getMinutes()
        seconds = date.getUTCSeconds();
        if(hours.length==1){
            hours="0"+hours;
        }
        if(minutes.length==1){
            minutes="0"+minutes;
        }
	
        if(value0 !=  hours.charAt(0)){

            value0=hours.charAt(0)
            hour0.valueChanged(value0);
        }
        if(value1 !=  hours.charAt(1)){

            value1=hours.charAt(1)
            hour1.valueChanged(value1);
        }
        if(value2 !=  minutes.charAt(0)){

            value2=minutes.charAt(0)
            hour2.valueChanged(value2);
        }
        if(value3 !=  minutes.charAt(1)){
            value3 = minutes.charAt(1);
            hour3.valueChanged(value3);
        }
    }
    
    Timer {
        interval: 100; running: true; repeat: true;
      onTriggered: clock.timeChanged()
    }
    
  


    width: 177; height: 82
    color: "transparent"
    Image { id: background; x: 0; y: 0; anchors.rightMargin: 0; anchors.bottomMargin: 0; anchors.leftMargin: 0; anchors.topMargin: 0; anchors.fill: parent; source: "content/background.png";

        Text {
            id: text1
            x: 41
            y: 13
            width: 95
            height: 14
            text: prop.title
            font.italic: false
            font.bold: true
            style: Text.Normal
            verticalAlignment: Text.AlignTop
            transformOrigin: Item.Center
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 14
        }
    }


    Rectangle {
        color: "transparent"
        anchors.rightMargin: 13
        anchors.leftMargin: 13
        anchors.bottomMargin: 14
        anchors.topMargin: 31
        anchors.fill: parent

        Row {
            anchors.centerIn: parent; spacing: 0

            Item { id: hour0}

            Item {id: hour1 }

            Image {
                source:"content/images/sep2.png";
                smooth: true
            }

            Item {id: hour2 }

            Item {id: hour3 }

        }
    }



}
