/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 1.0
import "content"

Rectangle {
    id: main
    signal cpuValue(int cpu)
    onCpuValue: cpuProgress.value = cpu;
    signal memValue(int mem)
    onMemValue:  memProgress.value = mem;
    signal swapValue(int swap)
    onSwapValue:   swapProgress.value = swap;
    signal sysInfo(string sys)
    onSysInfo:    mSys.text = sys;

    width: 260; height: 380
    color: "transparent"
property date showDate: new Date()
  Image { id: background; source: "content/bkg.png"; /*visible: clock.night == false*/ }
        Column {
            id: column1
            x: 13
            y: 5
            width: 232
            height: 367
            anchors.verticalCenterOffset: 0
            anchors.horizontalCenterOffset: 0
            spacing: 6
            anchors.centerIn: parent

            Text {
                    id: mSys

                    color: "black"
                    wrapMode: Text.WordWrap
                    text:"sys"
                    anchors.top: parent.top
                    anchors.topMargin: 10
                    anchors.left: parent.left
                    anchors.leftMargin: 4
                    anchors.right: parent.right
                    anchors.rightMargin: 4
                    verticalAlignment: Text.AlignTop
                    font.bold: true; font.pixelSize: 10
                    style: Text.Raised; styleColor: "white"
                    font.family: "Nimbus Mono L"
                    horizontalAlignment: Text.AlignHCenter
                }

            Clock {
                id: cock
                anchors.horizontalCenter: parent.horizontalCenter

            }
            Text {
                    id: dateT

                    color: "black"
                    text: Qt.formatDateTime(showDate, "dd MMMM yyyy")
                    verticalAlignment: Text.AlignVCenter
                    font.bold: true; font.pixelSize: 18
                    style: Text.Raised; styleColor: "white"
                    font.family: "Neuropolitical"
                    anchors.horizontalCenterOffset: 0
                    horizontalAlignment: Text.AlignHCenter
                    anchors.horizontalCenter: parent.horizontalCenter
                }
            ProgressBar {
               id: cpuProgress
               width: 200

                anchors.horizontalCenter: parent.horizontalCenter

                color: "lightsteelblue"
                secondColor:  "#24aa00"
                value : 0
                caption: "Cpu :"
           }
            ProgressBar {
               id: memProgress
               width: 200

                anchors.horizontalCenter: parent.horizontalCenter
                color: "lightsteelblue"
                secondColor:  "#24aa00"
                value : 0
                caption: "Mem :"
           }
            ProgressBar {
               id: swapProgress
               width: 200

                anchors.horizontalCenter: parent.horizontalCenter
                color: "lightsteelblue"
                secondColor:  "#24aa00"
                value : 100
                caption: "Swap :"
           }


    }
}
